/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iam.model.AssignmentStatusType;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVirtualMfaDevicesRequest
extends IamRequest
implements ToCopyableBuilder<Builder, ListVirtualMfaDevicesRequest> {
    private final String assignmentStatus;
    private final String marker;
    private final Integer maxItems;

    private ListVirtualMfaDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.assignmentStatus = builder.assignmentStatus;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public AssignmentStatusType assignmentStatus() {
        return AssignmentStatusType.fromValue(this.assignmentStatus);
    }

    public String assignmentStatusAsString() {
        return this.assignmentStatus;
    }

    public String marker() {
        return this.marker;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualMfaDevicesRequest)) {
            return false;
        }
        ListVirtualMfaDevicesRequest other = (ListVirtualMfaDevicesRequest)((Object)obj);
        return Objects.equals(this.assignmentStatusAsString(), other.assignmentStatusAsString()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListVirtualMfaDevicesRequest").add("AssignmentStatus", (Object)this.assignmentStatusAsString()).add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssignmentStatus": {
                return Optional.ofNullable(clazz.cast(this.assignmentStatusAsString()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String assignmentStatus;
        private String marker;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualMfaDevicesRequest model) {
            super(model);
            this.assignmentStatus(model.assignmentStatus);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final String getAssignmentStatus() {
            return this.assignmentStatus;
        }

        @Override
        public final Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        @Override
        public final Builder assignmentStatus(AssignmentStatusType assignmentStatus) {
            this.assignmentStatus(assignmentStatus.toString());
            return this;
        }

        public final void setAssignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListVirtualMfaDevicesRequest build() {
            return new ListVirtualMfaDevicesRequest(this);
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    CopyableBuilder<Builder, ListVirtualMfaDevicesRequest> {
        public Builder assignmentStatus(String var1);

        public Builder assignmentStatus(AssignmentStatusType var1);

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

