/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.ServiceSpecificCredentialMetadata;
import software.amazon.awssdk.services.iam.model.ServiceSpecificCredentialsListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceSpecificCredentialsResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListServiceSpecificCredentialsResponse> {
    private final List<ServiceSpecificCredentialMetadata> serviceSpecificCredentials;

    private ListServiceSpecificCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceSpecificCredentials = builder.serviceSpecificCredentials;
    }

    public List<ServiceSpecificCredentialMetadata> serviceSpecificCredentials() {
        return this.serviceSpecificCredentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSpecificCredentials());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceSpecificCredentialsResponse)) {
            return false;
        }
        ListServiceSpecificCredentialsResponse other = (ListServiceSpecificCredentialsResponse)((Object)obj);
        return Objects.equals(this.serviceSpecificCredentials(), other.serviceSpecificCredentials());
    }

    public String toString() {
        return ToString.builder((String)"ListServiceSpecificCredentialsResponse").add("ServiceSpecificCredentials", this.serviceSpecificCredentials()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceSpecificCredentials": {
                return Optional.ofNullable(clazz.cast(this.serviceSpecificCredentials()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<ServiceSpecificCredentialMetadata> serviceSpecificCredentials = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceSpecificCredentialsResponse model) {
            super(model);
            this.serviceSpecificCredentials(model.serviceSpecificCredentials);
        }

        public final Collection<ServiceSpecificCredentialMetadata.Builder> getServiceSpecificCredentials() {
            return this.serviceSpecificCredentials != null ? (Collection)this.serviceSpecificCredentials.stream().map(ServiceSpecificCredentialMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceSpecificCredentials(Collection<ServiceSpecificCredentialMetadata> serviceSpecificCredentials) {
            this.serviceSpecificCredentials = ServiceSpecificCredentialsListTypeCopier.copy(serviceSpecificCredentials);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceSpecificCredentials(ServiceSpecificCredentialMetadata ... serviceSpecificCredentials) {
            this.serviceSpecificCredentials(Arrays.asList(serviceSpecificCredentials));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceSpecificCredentials(Consumer<ServiceSpecificCredentialMetadata.Builder> ... serviceSpecificCredentials) {
            this.serviceSpecificCredentials(Stream.of(serviceSpecificCredentials).map(c -> (ServiceSpecificCredentialMetadata)((ServiceSpecificCredentialMetadata.Builder)ServiceSpecificCredentialMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceSpecificCredentials(Collection<ServiceSpecificCredentialMetadata.BuilderImpl> serviceSpecificCredentials) {
            this.serviceSpecificCredentials = ServiceSpecificCredentialsListTypeCopier.copyFromBuilder(serviceSpecificCredentials);
        }

        @Override
        public ListServiceSpecificCredentialsResponse build() {
            return new ListServiceSpecificCredentialsResponse(this);
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    CopyableBuilder<Builder, ListServiceSpecificCredentialsResponse> {
        public Builder serviceSpecificCredentials(Collection<ServiceSpecificCredentialMetadata> var1);

        public Builder serviceSpecificCredentials(ServiceSpecificCredentialMetadata ... var1);

        public Builder serviceSpecificCredentials(Consumer<ServiceSpecificCredentialMetadata.Builder> ... var1);
    }
}

