/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iam.model.EntityType;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEntitiesForPolicyRequest
extends IamRequest
implements ToCopyableBuilder<Builder, ListEntitiesForPolicyRequest> {
    private final String policyArn;
    private final String entityFilter;
    private final String pathPrefix;
    private final String marker;
    private final Integer maxItems;

    private ListEntitiesForPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.entityFilter = builder.entityFilter;
        this.pathPrefix = builder.pathPrefix;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public String policyArn() {
        return this.policyArn;
    }

    public EntityType entityFilter() {
        return EntityType.fromValue(this.entityFilter);
    }

    public String entityFilterAsString() {
        return this.entityFilter;
    }

    public String pathPrefix() {
        return this.pathPrefix;
    }

    public String marker() {
        return this.marker;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesForPolicyRequest)) {
            return false;
        }
        ListEntitiesForPolicyRequest other = (ListEntitiesForPolicyRequest)((Object)obj);
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.entityFilterAsString(), other.entityFilterAsString()) && Objects.equals(this.pathPrefix(), other.pathPrefix()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListEntitiesForPolicyRequest").add("PolicyArn", (Object)this.policyArn()).add("EntityFilter", (Object)this.entityFilterAsString()).add("PathPrefix", (Object)this.pathPrefix()).add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "EntityFilter": {
                return Optional.ofNullable(clazz.cast(this.entityFilterAsString()));
            }
            case "PathPrefix": {
                return Optional.ofNullable(clazz.cast(this.pathPrefix()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String policyArn;
        private String entityFilter;
        private String pathPrefix;
        private String marker;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesForPolicyRequest model) {
            super(model);
            this.policyArn(model.policyArn);
            this.entityFilter(model.entityFilter);
            this.pathPrefix(model.pathPrefix);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public final String getEntityFilter() {
            return this.entityFilter;
        }

        @Override
        public final Builder entityFilter(String entityFilter) {
            this.entityFilter = entityFilter;
            return this;
        }

        @Override
        public final Builder entityFilter(EntityType entityFilter) {
            this.entityFilter(entityFilter.toString());
            return this;
        }

        public final void setEntityFilter(String entityFilter) {
            this.entityFilter = entityFilter;
        }

        public final String getPathPrefix() {
            return this.pathPrefix;
        }

        @Override
        public final Builder pathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
            return this;
        }

        public final void setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEntitiesForPolicyRequest build() {
            return new ListEntitiesForPolicyRequest(this);
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    CopyableBuilder<Builder, ListEntitiesForPolicyRequest> {
        public Builder policyArn(String var1);

        public Builder entityFilter(String var1);

        public Builder entityFilter(EntityType var1);

        public Builder pathPrefix(String var1);

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

