/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.SummaryKeyType;
import software.amazon.awssdk.services.iam.model._summaryMapTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccountSummaryResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetAccountSummaryResponse> {
    private final Map<String, Integer> summaryMap;

    private GetAccountSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.summaryMap = builder.summaryMap;
    }

    public Map<SummaryKeyType, Integer> summaryMap() {
        return TypeConverter.convert(this.summaryMap, SummaryKeyType::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)SummaryKeyType.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, Integer> summaryMapAsStrings() {
        return this.summaryMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.summaryMapAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountSummaryResponse)) {
            return false;
        }
        GetAccountSummaryResponse other = (GetAccountSummaryResponse)((Object)obj);
        return Objects.equals(this.summaryMapAsStrings(), other.summaryMapAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"GetAccountSummaryResponse").add("SummaryMap", this.summaryMapAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SummaryMap": {
                return Optional.ofNullable(clazz.cast(this.summaryMapAsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private Map<String, Integer> summaryMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountSummaryResponse model) {
            super(model);
            this.summaryMapWithStrings(model.summaryMap);
        }

        public final Map<String, Integer> getSummaryMap() {
            return this.summaryMap;
        }

        @Override
        public final Builder summaryMapWithStrings(Map<String, Integer> summaryMap) {
            this.summaryMap = _summaryMapTypeCopier.copy(summaryMap);
            return this;
        }

        @Override
        public final Builder summaryMap(Map<SummaryKeyType, Integer> summaryMap) {
            this.summaryMap = _summaryMapTypeCopier.copyEnumToString(summaryMap);
            return this;
        }

        public final void setSummaryMap(Map<String, Integer> summaryMap) {
            this.summaryMap = _summaryMapTypeCopier.copy(summaryMap);
        }

        @Override
        public GetAccountSummaryResponse build() {
            return new GetAccountSummaryResponse(this);
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    CopyableBuilder<Builder, GetAccountSummaryResponse> {
        public Builder summaryMapWithStrings(Map<String, Integer> var1);

        public Builder summaryMap(Map<SummaryKeyType, Integer> var1);
    }
}

