/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.EntityType;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.services.iam.model._entityListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccountAuthorizationDetailsRequest
extends IamRequest
implements ToCopyableBuilder<Builder, GetAccountAuthorizationDetailsRequest> {
    private final List<String> filter;
    private final Integer maxItems;
    private final String marker;

    private GetAccountAuthorizationDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
    }

    public List<EntityType> filter() {
        return TypeConverter.convert(this.filter, EntityType::fromValue);
    }

    public List<String> filterAsStrings() {
        return this.filter;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountAuthorizationDetailsRequest)) {
            return false;
        }
        GetAccountAuthorizationDetailsRequest other = (GetAccountAuthorizationDetailsRequest)((Object)obj);
        return Objects.equals(this.filterAsStrings(), other.filterAsStrings()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"GetAccountAuthorizationDetailsRequest").add("Filter", this.filterAsStrings()).add("MaxItems", (Object)this.maxItems()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filterAsStrings()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private List<String> filter = DefaultSdkAutoConstructList.getInstance();
        private Integer maxItems;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountAuthorizationDetailsRequest model) {
            super(model);
            this.filterWithStrings(model.filter);
            this.maxItems(model.maxItems);
            this.marker(model.marker);
        }

        public final Collection<String> getFilter() {
            return this.filter;
        }

        @Override
        public final Builder filterWithStrings(Collection<String> filter) {
            this.filter = _entityListTypeCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterWithStrings(String ... filter) {
            this.filterWithStrings(Arrays.asList(filter));
            return this;
        }

        @Override
        public final Builder filter(Collection<EntityType> filter) {
            this.filter = _entityListTypeCopier.copyEnumToString(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(EntityType ... filter) {
            this.filter(Arrays.asList(filter));
            return this;
        }

        public final void setFilter(Collection<String> filter) {
            this.filter = _entityListTypeCopier.copy(filter);
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAccountAuthorizationDetailsRequest build() {
            return new GetAccountAuthorizationDetailsRequest(this);
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    CopyableBuilder<Builder, GetAccountAuthorizationDetailsRequest> {
        public Builder filterWithStrings(Collection<String> var1);

        public Builder filterWithStrings(String ... var1);

        public Builder filter(Collection<EntityType> var1);

        public Builder filter(EntityType ... var1);

        public Builder maxItems(Integer var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

