/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.UpdateAccessKeyRequest;

public class UpdateAccessKeyRequestMarshaller
implements Marshaller<Request<UpdateAccessKeyRequest>, UpdateAccessKeyRequest> {
    public Request<UpdateAccessKeyRequest> marshall(UpdateAccessKeyRequest updateAccessKeyRequest) {
        if (updateAccessKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)updateAccessKeyRequest, "IAMClient");
        request.addParameter("Action", "UpdateAccessKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateAccessKeyRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)updateAccessKeyRequest.userName()));
        }
        if (updateAccessKeyRequest.accessKeyId() != null) {
            request.addParameter("AccessKeyId", StringUtils.fromString((String)updateAccessKeyRequest.accessKeyId()));
        }
        if (updateAccessKeyRequest.statusAsString() != null) {
            request.addParameter("Status", StringUtils.fromString((String)updateAccessKeyRequest.statusAsString()));
        }
        return request;
    }
}

