/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapEntry;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iam.model.EvaluationResult;
import software.amazon.awssdk.services.iam.model.ResourceSpecificResult;
import software.amazon.awssdk.services.iam.model.Statement;
import software.amazon.awssdk.services.iam.transform.OrganizationsDecisionDetailUnmarshaller;
import software.amazon.awssdk.services.iam.transform.ResourceSpecificResultUnmarshaller;
import software.amazon.awssdk.services.iam.transform.StatementUnmarshaller;

public class EvaluationResultUnmarshaller
implements Unmarshaller<EvaluationResult, StaxUnmarshallerContext> {
    private static final EvaluationResultUnmarshaller INSTANCE = new EvaluationResultUnmarshaller();

    public EvaluationResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        EvaluationResult.Builder evaluationResult;
        block15: {
            evaluationResult = EvaluationResult.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Statement> matchedStatements = null;
            ArrayList<String> missingContextValues = null;
            HashMap<String, String> evalDecisionDetails = null;
            ArrayList<ResourceSpecificResult> resourceSpecificResults = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    evaluationResult.matchedStatements(matchedStatements);
                    evaluationResult.missingContextValues(missingContextValues);
                    evaluationResult.evalDecisionDetails(evalDecisionDetails);
                    evaluationResult.resourceSpecificResults(resourceSpecificResults);
                    break block15;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("EvalActionName", targetDepth)) {
                        evaluationResult.evalActionName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EvalResourceName", targetDepth)) {
                        evaluationResult.evalResourceName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EvalDecision", targetDepth)) {
                        evaluationResult.evalDecision(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MatchedStatements", targetDepth)) {
                        matchedStatements = new ArrayList<Statement>();
                        continue;
                    }
                    if (context.testExpression("MatchedStatements/member", targetDepth)) {
                        matchedStatements.add(StatementUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MissingContextValues", targetDepth)) {
                        missingContextValues = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("MissingContextValues/member", targetDepth)) {
                        missingContextValues.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("OrganizationsDecisionDetail", targetDepth)) {
                        evaluationResult.organizationsDecisionDetail(OrganizationsDecisionDetailUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EvalDecisionDetails/entry", targetDepth)) {
                        if (evalDecisionDetails == null) {
                            evalDecisionDetails = new HashMap<String, String>();
                        }
                        Map.Entry<String, String> entry = EvalDecisionDetailsMapEntryUnmarshaller.getInstance().unmarshall(context);
                        evalDecisionDetails.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (context.testExpression("ResourceSpecificResults", targetDepth)) {
                        resourceSpecificResults = new ArrayList<ResourceSpecificResult>();
                        continue;
                    }
                    if (!context.testExpression("ResourceSpecificResults/member", targetDepth)) continue;
                    resourceSpecificResults.add(ResourceSpecificResultUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            evaluationResult.matchedStatements(matchedStatements);
            evaluationResult.missingContextValues(missingContextValues);
            evaluationResult.evalDecisionDetails(evalDecisionDetails);
            evaluationResult.resourceSpecificResults(resourceSpecificResults);
        }
        return (EvaluationResult)evaluationResult.build();
    }

    public static EvaluationResultUnmarshaller getInstance() {
        return INSTANCE;
    }

    private static class EvalDecisionDetailsMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static final EvalDecisionDetailsMapEntryUnmarshaller INSTANCE = new EvalDecisionDetailsMapEntryUnmarshaller();

        private EvalDecisionDetailsMapEntryUnmarshaller() {
        }

        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static EvalDecisionDetailsMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }
    }
}

