/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListSigningCertificatesRequest;
import software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse;
import software.amazon.awssdk.services.iam.model.SigningCertificate;

public class ListSigningCertificatesIterable
implements SdkIterable<ListSigningCertificatesResponse> {
    private final IAMClient client;
    private final ListSigningCertificatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSigningCertificatesIterable(IAMClient client, ListSigningCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSigningCertificatesResponseFetcher();
    }

    public Iterator<ListSigningCertificatesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<SigningCertificate> certificates() {
        Function<ListSigningCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.certificates() != null) {
                return response.certificates().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListSigningCertificatesIterable resume(ListSigningCertificatesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSigningCertificatesIterable(this.client, (ListSigningCertificatesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListSigningCertificatesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListSigningCertificatesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListSigningCertificatesResponseFetcher
    implements SyncPageFetcher<ListSigningCertificatesResponse> {
        private ListSigningCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListSigningCertificatesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListSigningCertificatesResponse nextPage(ListSigningCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListSigningCertificatesIterable.this.client.listSigningCertificates(ListSigningCertificatesIterable.this.firstRequest);
            }
            return ListSigningCertificatesIterable.this.client.listSigningCertificates((ListSigningCertificatesRequest)((Object)ListSigningCertificatesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

