/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListSSHPublicKeysRequest;
import software.amazon.awssdk.services.iam.model.ListSSHPublicKeysResponse;
import software.amazon.awssdk.services.iam.model.SSHPublicKeyMetadata;

public class ListSSHPublicKeysIterable
implements SdkIterable<ListSSHPublicKeysResponse> {
    private final IAMClient client;
    private final ListSSHPublicKeysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSSHPublicKeysIterable(IAMClient client, ListSSHPublicKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSSHPublicKeysResponseFetcher();
    }

    public Iterator<ListSSHPublicKeysResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<SSHPublicKeyMetadata> sshPublicKeys() {
        Function<ListSSHPublicKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.sshPublicKeys() != null) {
                return response.sshPublicKeys().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListSSHPublicKeysIterable resume(ListSSHPublicKeysResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSSHPublicKeysIterable(this.client, (ListSSHPublicKeysRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListSSHPublicKeysIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListSSHPublicKeysResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListSSHPublicKeysResponseFetcher
    implements SyncPageFetcher<ListSSHPublicKeysResponse> {
        private ListSSHPublicKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListSSHPublicKeysResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListSSHPublicKeysResponse nextPage(ListSSHPublicKeysResponse previousPage) {
            if (previousPage == null) {
                return ListSSHPublicKeysIterable.this.client.listSSHPublicKeys(ListSSHPublicKeysIterable.this.firstRequest);
            }
            return ListSSHPublicKeysIterable.this.client.listSSHPublicKeys((ListSSHPublicKeysRequest)((Object)ListSSHPublicKeysIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

