/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.iam.IAMAsyncClient;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse;
import software.amazon.awssdk.services.iam.model.PolicyVersion;

public class ListPolicyVersionsPublisher
implements SdkPublisher<ListPolicyVersionsResponse> {
    private final IAMAsyncClient client;
    private final ListPolicyVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPolicyVersionsPublisher(IAMAsyncClient client, ListPolicyVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPolicyVersionsPublisher(IAMAsyncClient client, ListPolicyVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPolicyVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPolicyVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<PolicyVersion> versions() {
        Function<ListPolicyVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.versions() != null) {
                return response.versions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListPolicyVersionsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListPolicyVersionsPublisher resume(ListPolicyVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPolicyVersionsPublisher(this.client, (ListPolicyVersionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListPolicyVersionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListPolicyVersionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListPolicyVersionsResponseFetcher
    implements AsyncPageFetcher<ListPolicyVersionsResponse> {
        private ListPolicyVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyVersionsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListPolicyVersionsResponse> nextPage(ListPolicyVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyVersionsPublisher.this.client.listPolicyVersions(ListPolicyVersionsPublisher.this.firstRequest);
            }
            return ListPolicyVersionsPublisher.this.client.listPolicyVersions((ListPolicyVersionsRequest)((Object)ListPolicyVersionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

