/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListPoliciesResponse;
import software.amazon.awssdk.services.iam.model.Policy;

public class ListPoliciesIterable
implements SdkIterable<ListPoliciesResponse> {
    private final IAMClient client;
    private final ListPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPoliciesIterable(IAMClient client, ListPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPoliciesResponseFetcher();
    }

    public Iterator<ListPoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Policy> policies() {
        Function<ListPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policies() != null) {
                return response.policies().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListPoliciesIterable resume(ListPoliciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPoliciesIterable(this.client, (ListPoliciesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListPoliciesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListPoliciesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListPoliciesResponseFetcher
    implements SyncPageFetcher<ListPoliciesResponse> {
        private ListPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListPoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListPoliciesResponse nextPage(ListPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListPoliciesIterable.this.client.listPolicies(ListPoliciesIterable.this.firstRequest);
            }
            return ListPoliciesIterable.this.client.listPolicies((ListPoliciesRequest)((Object)ListPoliciesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

