/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.InstanceProfile;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse;

public class ListInstanceProfilesIterable
implements SdkIterable<ListInstanceProfilesResponse> {
    private final IAMClient client;
    private final ListInstanceProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInstanceProfilesIterable(IAMClient client, ListInstanceProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInstanceProfilesResponseFetcher();
    }

    public Iterator<ListInstanceProfilesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<InstanceProfile> instanceProfiles() {
        Function<ListInstanceProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceProfiles() != null) {
                return response.instanceProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListInstanceProfilesIterable resume(ListInstanceProfilesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInstanceProfilesIterable(this.client, (ListInstanceProfilesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListInstanceProfilesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListInstanceProfilesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListInstanceProfilesResponseFetcher
    implements SyncPageFetcher<ListInstanceProfilesResponse> {
        private ListInstanceProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceProfilesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListInstanceProfilesResponse nextPage(ListInstanceProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceProfilesIterable.this.client.listInstanceProfiles(ListInstanceProfilesIterable.this.firstRequest);
            }
            return ListInstanceProfilesIterable.this.client.listInstanceProfiles((ListInstanceProfilesRequest)((Object)ListInstanceProfilesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

