/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.iam.IAMAsyncClient;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse;

public class ListAttachedRolePoliciesPublisher
implements SdkPublisher<ListAttachedRolePoliciesResponse> {
    private final IAMAsyncClient client;
    private final ListAttachedRolePoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAttachedRolePoliciesPublisher(IAMAsyncClient client, ListAttachedRolePoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAttachedRolePoliciesPublisher(IAMAsyncClient client, ListAttachedRolePoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAttachedRolePoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAttachedRolePoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<AttachedPolicy> attachedPolicies() {
        Function<ListAttachedRolePoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.attachedPolicies() != null) {
                return response.attachedPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListAttachedRolePoliciesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListAttachedRolePoliciesPublisher resume(ListAttachedRolePoliciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAttachedRolePoliciesPublisher(this.client, (ListAttachedRolePoliciesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListAttachedRolePoliciesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListAttachedRolePoliciesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListAttachedRolePoliciesResponseFetcher
    implements AsyncPageFetcher<ListAttachedRolePoliciesResponse> {
        private ListAttachedRolePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedRolePoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListAttachedRolePoliciesResponse> nextPage(ListAttachedRolePoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedRolePoliciesPublisher.this.client.listAttachedRolePolicies(ListAttachedRolePoliciesPublisher.this.firstRequest);
            }
            return ListAttachedRolePoliciesPublisher.this.client.listAttachedRolePolicies((ListAttachedRolePoliciesRequest)((Object)ListAttachedRolePoliciesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

