/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.GetGroupRequest;
import software.amazon.awssdk.services.iam.model.GetGroupResponse;
import software.amazon.awssdk.services.iam.model.User;

public class GetGroupIterable
implements SdkIterable<GetGroupResponse> {
    private final IAMClient client;
    private final GetGroupRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetGroupIterable(IAMClient client, GetGroupRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetGroupResponseFetcher();
    }

    public Iterator<GetGroupResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<User> users() {
        Function<GetGroupResponse, Iterator> getIterator = response -> {
            if (response != null && response.users() != null) {
                return response.users().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final GetGroupIterable resume(GetGroupResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetGroupIterable(this.client, (GetGroupRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new GetGroupIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetGroupResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetGroupResponseFetcher
    implements SyncPageFetcher<GetGroupResponse> {
        private GetGroupResponseFetcher() {
        }

        public boolean hasNextPage(GetGroupResponse previousPage) {
            return previousPage.isTruncated();
        }

        public GetGroupResponse nextPage(GetGroupResponse previousPage) {
            if (previousPage == null) {
                return GetGroupIterable.this.client.getGroup(GetGroupIterable.this.firstRequest);
            }
            return GetGroupIterable.this.client.getGroup((GetGroupRequest)((Object)GetGroupIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

