/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ServerCertificateMetadata
implements ToCopyableBuilder<Builder, ServerCertificateMetadata> {
    private final String path;
    private final String serverCertificateName;
    private final String serverCertificateId;
    private final String arn;
    private final Instant uploadDate;
    private final Instant expiration;

    private ServerCertificateMetadata(BuilderImpl builder) {
        this.path = builder.path;
        this.serverCertificateName = builder.serverCertificateName;
        this.serverCertificateId = builder.serverCertificateId;
        this.arn = builder.arn;
        this.uploadDate = builder.uploadDate;
        this.expiration = builder.expiration;
    }

    public String path() {
        return this.path;
    }

    public String serverCertificateName() {
        return this.serverCertificateName;
    }

    public String serverCertificateId() {
        return this.serverCertificateId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant uploadDate() {
        return this.uploadDate;
    }

    public Instant expiration() {
        return this.expiration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerCertificateMetadata)) {
            return false;
        }
        ServerCertificateMetadata other = (ServerCertificateMetadata)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.serverCertificateName(), other.serverCertificateName()) && Objects.equals(this.serverCertificateId(), other.serverCertificateId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.uploadDate(), other.uploadDate()) && Objects.equals(this.expiration(), other.expiration());
    }

    public String toString() {
        return ToString.builder((String)"ServerCertificateMetadata").add("Path", (Object)this.path()).add("ServerCertificateName", (Object)this.serverCertificateName()).add("ServerCertificateId", (Object)this.serverCertificateId()).add("Arn", (Object)this.arn()).add("UploadDate", (Object)this.uploadDate()).add("Expiration", (Object)this.expiration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.of(clazz.cast(this.path()));
            }
            case "ServerCertificateName": {
                return Optional.of(clazz.cast(this.serverCertificateName()));
            }
            case "ServerCertificateId": {
                return Optional.of(clazz.cast(this.serverCertificateId()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "UploadDate": {
                return Optional.of(clazz.cast(this.uploadDate()));
            }
            case "Expiration": {
                return Optional.of(clazz.cast(this.expiration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String serverCertificateName;
        private String serverCertificateId;
        private String arn;
        private Instant uploadDate;
        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerCertificateMetadata model) {
            this.path(model.path);
            this.serverCertificateName(model.serverCertificateName);
            this.serverCertificateId(model.serverCertificateId);
            this.arn(model.arn);
            this.uploadDate(model.uploadDate);
            this.expiration(model.expiration);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getServerCertificateName() {
            return this.serverCertificateName;
        }

        @Override
        public final Builder serverCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
            return this;
        }

        public final void setServerCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
        }

        public final String getServerCertificateId() {
            return this.serverCertificateId;
        }

        @Override
        public final Builder serverCertificateId(String serverCertificateId) {
            this.serverCertificateId = serverCertificateId;
            return this;
        }

        public final void setServerCertificateId(String serverCertificateId) {
            this.serverCertificateId = serverCertificateId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getUploadDate() {
            return this.uploadDate;
        }

        @Override
        public final Builder uploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
            return this;
        }

        public final void setUploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
        }

        public final Instant getExpiration() {
            return this.expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        public ServerCertificateMetadata build() {
            return new ServerCertificateMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ServerCertificateMetadata> {
        public Builder path(String var1);

        public Builder serverCertificateName(String var1);

        public Builder serverCertificateId(String var1);

        public Builder arn(String var1);

        public Builder uploadDate(Instant var1);

        public Builder expiration(Instant var1);
    }
}

