/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.iam.model.IAMResponse;
import software.amazon.awssdk.services.iam.model.Role;
import software.amazon.awssdk.services.iam.model._roleListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRolesResponse
extends IAMResponse
implements ToCopyableBuilder<Builder, ListRolesResponse> {
    private final List<Role> roles;
    private final Boolean isTruncated;
    private final String marker;

    private ListRolesResponse(BuilderImpl builder) {
        super(builder);
        this.roles = builder.roles;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<Role> roles() {
        return this.roles;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roles());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRolesResponse)) {
            return false;
        }
        ListRolesResponse other = (ListRolesResponse)((Object)obj);
        return Objects.equals(this.roles(), other.roles()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListRolesResponse").add("Roles", this.roles()).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Roles": {
                return Optional.of(clazz.cast(this.roles()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMResponse.BuilderImpl
    implements Builder {
        private List<Role> roles;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRolesResponse model) {
            super(model);
            this.roles(model.roles);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<Role.Builder> getRoles() {
            return this.roles != null ? (Collection)this.roles.stream().map(Role::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder roles(Collection<Role> roles) {
            this.roles = _roleListTypeCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Role ... roles) {
            this.roles(Arrays.asList(roles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Consumer<Role.Builder> ... roles) {
            this.roles(Stream.of(roles).map(c -> (Role)((Role.Builder)Role.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoles(Collection<Role.BuilderImpl> roles) {
            this.roles = _roleListTypeCopier.copyFromBuilder(roles);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListRolesResponse build() {
            return new ListRolesResponse(this);
        }
    }

    public static interface Builder
    extends IAMResponse.Builder,
    CopyableBuilder<Builder, ListRolesResponse> {
        public Builder roles(Collection<Role> var1);

        public Builder roles(Role ... var1);

        public Builder roles(Consumer<Role.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

