/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.iam.model.IAMResponse;
import software.amazon.awssdk.services.iam.model._accountAliasListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAccountAliasesResponse
extends IAMResponse
implements ToCopyableBuilder<Builder, ListAccountAliasesResponse> {
    private final List<String> accountAliases;
    private final Boolean isTruncated;
    private final String marker;

    private ListAccountAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.accountAliases = builder.accountAliases;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<String> accountAliases() {
        return this.accountAliases;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAliases());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountAliasesResponse)) {
            return false;
        }
        ListAccountAliasesResponse other = (ListAccountAliasesResponse)((Object)obj);
        return Objects.equals(this.accountAliases(), other.accountAliases()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListAccountAliasesResponse").add("AccountAliases", this.accountAliases()).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountAliases": {
                return Optional.of(clazz.cast(this.accountAliases()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMResponse.BuilderImpl
    implements Builder {
        private List<String> accountAliases;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountAliasesResponse model) {
            super(model);
            this.accountAliases(model.accountAliases);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<String> getAccountAliases() {
            return this.accountAliases;
        }

        @Override
        public final Builder accountAliases(Collection<String> accountAliases) {
            this.accountAliases = _accountAliasListTypeCopier.copy(accountAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAliases(String ... accountAliases) {
            this.accountAliases(Arrays.asList(accountAliases));
            return this;
        }

        public final void setAccountAliases(Collection<String> accountAliases) {
            this.accountAliases = _accountAliasListTypeCopier.copy(accountAliases);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListAccountAliasesResponse build() {
            return new ListAccountAliasesResponse(this);
        }
    }

    public static interface Builder
    extends IAMResponse.Builder,
    CopyableBuilder<Builder, ListAccountAliasesResponse> {
        public Builder accountAliases(Collection<String> var1);

        public Builder accountAliases(String ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

