/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Group
implements ToCopyableBuilder<Builder, Group> {
    private final String path;
    private final String groupName;
    private final String groupId;
    private final String arn;
    private final Instant createDate;

    private Group(BuilderImpl builder) {
        this.path = builder.path;
        this.groupName = builder.groupName;
        this.groupId = builder.groupId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
    }

    public String path() {
        return this.path;
    }

    public String groupName() {
        return this.groupName;
    }

    public String groupId() {
        return this.groupId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createDate(), other.createDate());
    }

    public String toString() {
        return ToString.builder((String)"Group").add("Path", (Object)this.path()).add("GroupName", (Object)this.groupName()).add("GroupId", (Object)this.groupId()).add("Arn", (Object)this.arn()).add("CreateDate", (Object)this.createDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.of(clazz.cast(this.path()));
            }
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
            case "GroupId": {
                return Optional.of(clazz.cast(this.groupId()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String groupName;
        private String groupId;
        private String arn;
        private Instant createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Group model) {
            this.path(model.path);
            this.groupName(model.groupName);
            this.groupId(model.groupId);
            this.arn(model.arn);
            this.createDate(model.createDate);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public Group build() {
            return new Group(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Group> {
        public Builder path(String var1);

        public Builder groupName(String var1);

        public Builder groupId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);
    }
}

