/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteGroupPolicyRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, DeleteGroupPolicyRequest> {
    private final String groupName;
    private final String policyName;

    private DeleteGroupPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.policyName = builder.policyName;
    }

    public String groupName() {
        return this.groupName;
    }

    public String policyName() {
        return this.policyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteGroupPolicyRequest)) {
            return false;
        }
        DeleteGroupPolicyRequest other = (DeleteGroupPolicyRequest)((Object)obj);
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.policyName(), other.policyName());
    }

    public String toString() {
        return ToString.builder((String)"DeleteGroupPolicyRequest").add("GroupName", (Object)this.groupName()).add("PolicyName", (Object)this.policyName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String groupName;
        private String policyName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteGroupPolicyRequest model) {
            super(model);
            this.groupName(model.groupName);
            this.policyName(model.policyName);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteGroupPolicyRequest build() {
            return new DeleteGroupPolicyRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, DeleteGroupPolicyRequest> {
        public Builder groupName(String var1);

        public Builder policyName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

