/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.UploadServerCertificateRequest;
import software.amazon.awssdk.util.StringUtils;

public class UploadServerCertificateRequestMarshaller
implements Marshaller<Request<UploadServerCertificateRequest>, UploadServerCertificateRequest> {
    public Request<UploadServerCertificateRequest> marshall(UploadServerCertificateRequest uploadServerCertificateRequest) {
        if (uploadServerCertificateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)uploadServerCertificateRequest, "IAMClient");
        request.addParameter("Action", "UploadServerCertificate");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (uploadServerCertificateRequest.path() != null) {
            request.addParameter("Path", StringUtils.fromString((String)uploadServerCertificateRequest.path()));
        }
        if (uploadServerCertificateRequest.serverCertificateName() != null) {
            request.addParameter("ServerCertificateName", StringUtils.fromString((String)uploadServerCertificateRequest.serverCertificateName()));
        }
        if (uploadServerCertificateRequest.certificateBody() != null) {
            request.addParameter("CertificateBody", StringUtils.fromString((String)uploadServerCertificateRequest.certificateBody()));
        }
        if (uploadServerCertificateRequest.privateKey() != null) {
            request.addParameter("PrivateKey", StringUtils.fromString((String)uploadServerCertificateRequest.privateKey()));
        }
        if (uploadServerCertificateRequest.certificateChain() != null) {
            request.addParameter("CertificateChain", StringUtils.fromString((String)uploadServerCertificateRequest.certificateChain()));
        }
        return request;
    }
}

