/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ListRolesRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListRolesRequestMarshaller
implements Marshaller<Request<ListRolesRequest>, ListRolesRequest> {
    public Request<ListRolesRequest> marshall(ListRolesRequest listRolesRequest) {
        if (listRolesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listRolesRequest, "IAMClient");
        request.addParameter("Action", "ListRoles");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listRolesRequest.pathPrefix() != null) {
            request.addParameter("PathPrefix", StringUtils.fromString((String)listRolesRequest.pathPrefix()));
        }
        if (listRolesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listRolesRequest.marker()));
        }
        if (listRolesRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listRolesRequest.maxItems()));
        }
        return request;
    }
}

