/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ListAccessKeysRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListAccessKeysRequestMarshaller
implements Marshaller<Request<ListAccessKeysRequest>, ListAccessKeysRequest> {
    public Request<ListAccessKeysRequest> marshall(ListAccessKeysRequest listAccessKeysRequest) {
        if (listAccessKeysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listAccessKeysRequest, "IAMClient");
        request.addParameter("Action", "ListAccessKeys");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listAccessKeysRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)listAccessKeysRequest.userName()));
        }
        if (listAccessKeysRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listAccessKeysRequest.marker()));
        }
        if (listAccessKeysRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listAccessKeysRequest.maxItems()));
        }
        return request;
    }
}

