/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.CreateUserRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateUserRequestMarshaller
implements Marshaller<Request<CreateUserRequest>, CreateUserRequest> {
    public Request<CreateUserRequest> marshall(CreateUserRequest createUserRequest) {
        if (createUserRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createUserRequest, "IAMClient");
        request.addParameter("Action", "CreateUser");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createUserRequest.path() != null) {
            request.addParameter("Path", StringUtils.fromString((String)createUserRequest.path()));
        }
        if (createUserRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)createUserRequest.userName()));
        }
        return request;
    }
}

