/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.CreateInstanceProfileRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateInstanceProfileRequestMarshaller
implements Marshaller<Request<CreateInstanceProfileRequest>, CreateInstanceProfileRequest> {
    public Request<CreateInstanceProfileRequest> marshall(CreateInstanceProfileRequest createInstanceProfileRequest) {
        if (createInstanceProfileRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createInstanceProfileRequest, "IAMClient");
        request.addParameter("Action", "CreateInstanceProfile");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createInstanceProfileRequest.instanceProfileName() != null) {
            request.addParameter("InstanceProfileName", StringUtils.fromString((String)createInstanceProfileRequest.instanceProfileName()));
        }
        if (createInstanceProfileRequest.path() != null) {
            request.addParameter("Path", StringUtils.fromString((String)createInstanceProfileRequest.path()));
        }
        return request;
    }
}

