/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.CreateAccessKeyRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateAccessKeyRequestMarshaller
implements Marshaller<Request<CreateAccessKeyRequest>, CreateAccessKeyRequest> {
    public Request<CreateAccessKeyRequest> marshall(CreateAccessKeyRequest createAccessKeyRequest) {
        if (createAccessKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createAccessKeyRequest, "IAMClient");
        request.addParameter("Action", "CreateAccessKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createAccessKeyRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)createAccessKeyRequest.userName()));
        }
        return request;
    }
}

