/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.iam.model._accountAliasListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAccountAliasesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListAccountAliasesResponse> {
    private final List<String> accountAliases;
    private final Boolean isTruncated;
    private final String marker;

    private ListAccountAliasesResponse(BuilderImpl builder) {
        this.accountAliases = builder.accountAliases;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<String> accountAliases() {
        return this.accountAliases;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountAliases() == null ? 0 : this.accountAliases().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountAliasesResponse)) {
            return false;
        }
        ListAccountAliasesResponse other = (ListAccountAliasesResponse)((Object)obj);
        if (other.accountAliases() == null ^ this.accountAliases() == null) {
            return false;
        }
        if (other.accountAliases() != null && !other.accountAliases().equals(this.accountAliases())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountAliases() != null) {
            sb.append("AccountAliases: ").append(this.accountAliases()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> accountAliases = new SdkInternalList();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountAliasesResponse model) {
            this.setAccountAliases(model.accountAliases);
            this.setIsTruncated(model.isTruncated);
            this.setMarker(model.marker);
        }

        public final Collection<String> getAccountAliases() {
            return this.accountAliases;
        }

        @Override
        public final Builder accountAliases(Collection<String> accountAliases) {
            this.accountAliases = _accountAliasListTypeCopier.copy(accountAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAliases(String ... accountAliases) {
            if (this.accountAliases == null) {
                this.accountAliases = new SdkInternalList(accountAliases.length);
            }
            for (String e : accountAliases) {
                this.accountAliases.add(e);
            }
            return this;
        }

        public final void setAccountAliases(Collection<String> accountAliases) {
            this.accountAliases = _accountAliasListTypeCopier.copy(accountAliases);
        }

        @SafeVarargs
        public final void setAccountAliases(String ... accountAliases) {
            if (this.accountAliases == null) {
                this.accountAliases = new SdkInternalList(accountAliases.length);
            }
            for (String e : accountAliases) {
                this.accountAliases.add(e);
            }
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListAccountAliasesResponse build() {
            return new ListAccountAliasesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListAccountAliasesResponse> {
        public Builder accountAliases(Collection<String> var1);

        public Builder accountAliases(String ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

