/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.iam.model.ContextKeyNamesResultListTypeCopier;
import software.amazon.awssdk.services.iam.model.EvalDecisionDetailsTypeCopier;
import software.amazon.awssdk.services.iam.model.OrganizationsDecisionDetail;
import software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType;
import software.amazon.awssdk.services.iam.model.ResourceSpecificResult;
import software.amazon.awssdk.services.iam.model.ResourceSpecificResultListTypeCopier;
import software.amazon.awssdk.services.iam.model.Statement;
import software.amazon.awssdk.services.iam.model.StatementListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EvaluationResult
implements ToCopyableBuilder<Builder, EvaluationResult> {
    private final String evalActionName;
    private final String evalResourceName;
    private final String evalDecision;
    private final List<Statement> matchedStatements;
    private final List<String> missingContextValues;
    private final OrganizationsDecisionDetail organizationsDecisionDetail;
    private final Map<String, String> evalDecisionDetails;
    private final List<ResourceSpecificResult> resourceSpecificResults;

    private EvaluationResult(BuilderImpl builder) {
        this.evalActionName = builder.evalActionName;
        this.evalResourceName = builder.evalResourceName;
        this.evalDecision = builder.evalDecision;
        this.matchedStatements = builder.matchedStatements;
        this.missingContextValues = builder.missingContextValues;
        this.organizationsDecisionDetail = builder.organizationsDecisionDetail;
        this.evalDecisionDetails = builder.evalDecisionDetails;
        this.resourceSpecificResults = builder.resourceSpecificResults;
    }

    public String evalActionName() {
        return this.evalActionName;
    }

    public String evalResourceName() {
        return this.evalResourceName;
    }

    public String evalDecision() {
        return this.evalDecision;
    }

    public List<Statement> matchedStatements() {
        return this.matchedStatements;
    }

    public List<String> missingContextValues() {
        return this.missingContextValues;
    }

    public OrganizationsDecisionDetail organizationsDecisionDetail() {
        return this.organizationsDecisionDetail;
    }

    public Map<String, String> evalDecisionDetails() {
        return this.evalDecisionDetails;
    }

    public List<ResourceSpecificResult> resourceSpecificResults() {
        return this.resourceSpecificResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.evalActionName() == null ? 0 : this.evalActionName().hashCode());
        hashCode = 31 * hashCode + (this.evalResourceName() == null ? 0 : this.evalResourceName().hashCode());
        hashCode = 31 * hashCode + (this.evalDecision() == null ? 0 : this.evalDecision().hashCode());
        hashCode = 31 * hashCode + (this.matchedStatements() == null ? 0 : this.matchedStatements().hashCode());
        hashCode = 31 * hashCode + (this.missingContextValues() == null ? 0 : this.missingContextValues().hashCode());
        hashCode = 31 * hashCode + (this.organizationsDecisionDetail() == null ? 0 : this.organizationsDecisionDetail().hashCode());
        hashCode = 31 * hashCode + (this.evalDecisionDetails() == null ? 0 : this.evalDecisionDetails().hashCode());
        hashCode = 31 * hashCode + (this.resourceSpecificResults() == null ? 0 : this.resourceSpecificResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResult)) {
            return false;
        }
        EvaluationResult other = (EvaluationResult)obj;
        if (other.evalActionName() == null ^ this.evalActionName() == null) {
            return false;
        }
        if (other.evalActionName() != null && !other.evalActionName().equals(this.evalActionName())) {
            return false;
        }
        if (other.evalResourceName() == null ^ this.evalResourceName() == null) {
            return false;
        }
        if (other.evalResourceName() != null && !other.evalResourceName().equals(this.evalResourceName())) {
            return false;
        }
        if (other.evalDecision() == null ^ this.evalDecision() == null) {
            return false;
        }
        if (other.evalDecision() != null && !other.evalDecision().equals(this.evalDecision())) {
            return false;
        }
        if (other.matchedStatements() == null ^ this.matchedStatements() == null) {
            return false;
        }
        if (other.matchedStatements() != null && !other.matchedStatements().equals(this.matchedStatements())) {
            return false;
        }
        if (other.missingContextValues() == null ^ this.missingContextValues() == null) {
            return false;
        }
        if (other.missingContextValues() != null && !other.missingContextValues().equals(this.missingContextValues())) {
            return false;
        }
        if (other.organizationsDecisionDetail() == null ^ this.organizationsDecisionDetail() == null) {
            return false;
        }
        if (other.organizationsDecisionDetail() != null && !other.organizationsDecisionDetail().equals(this.organizationsDecisionDetail())) {
            return false;
        }
        if (other.evalDecisionDetails() == null ^ this.evalDecisionDetails() == null) {
            return false;
        }
        if (other.evalDecisionDetails() != null && !other.evalDecisionDetails().equals(this.evalDecisionDetails())) {
            return false;
        }
        if (other.resourceSpecificResults() == null ^ this.resourceSpecificResults() == null) {
            return false;
        }
        return other.resourceSpecificResults() == null || other.resourceSpecificResults().equals(this.resourceSpecificResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.evalActionName() != null) {
            sb.append("EvalActionName: ").append(this.evalActionName()).append(",");
        }
        if (this.evalResourceName() != null) {
            sb.append("EvalResourceName: ").append(this.evalResourceName()).append(",");
        }
        if (this.evalDecision() != null) {
            sb.append("EvalDecision: ").append(this.evalDecision()).append(",");
        }
        if (this.matchedStatements() != null) {
            sb.append("MatchedStatements: ").append(this.matchedStatements()).append(",");
        }
        if (this.missingContextValues() != null) {
            sb.append("MissingContextValues: ").append(this.missingContextValues()).append(",");
        }
        if (this.organizationsDecisionDetail() != null) {
            sb.append("OrganizationsDecisionDetail: ").append(this.organizationsDecisionDetail()).append(",");
        }
        if (this.evalDecisionDetails() != null) {
            sb.append("EvalDecisionDetails: ").append(this.evalDecisionDetails()).append(",");
        }
        if (this.resourceSpecificResults() != null) {
            sb.append("ResourceSpecificResults: ").append(this.resourceSpecificResults()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String evalActionName;
        private String evalResourceName;
        private String evalDecision;
        private List<Statement> matchedStatements = new SdkInternalList();
        private List<String> missingContextValues = new SdkInternalList();
        private OrganizationsDecisionDetail organizationsDecisionDetail;
        private Map<String, String> evalDecisionDetails = new SdkInternalMap();
        private List<ResourceSpecificResult> resourceSpecificResults = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResult model) {
            this.setEvalActionName(model.evalActionName);
            this.setEvalResourceName(model.evalResourceName);
            this.setEvalDecision(model.evalDecision);
            this.setMatchedStatements(model.matchedStatements);
            this.setMissingContextValues(model.missingContextValues);
            this.setOrganizationsDecisionDetail(model.organizationsDecisionDetail);
            this.setEvalDecisionDetails(model.evalDecisionDetails);
            this.setResourceSpecificResults(model.resourceSpecificResults);
        }

        public final String getEvalActionName() {
            return this.evalActionName;
        }

        @Override
        public final Builder evalActionName(String evalActionName) {
            this.evalActionName = evalActionName;
            return this;
        }

        public final void setEvalActionName(String evalActionName) {
            this.evalActionName = evalActionName;
        }

        public final String getEvalResourceName() {
            return this.evalResourceName;
        }

        @Override
        public final Builder evalResourceName(String evalResourceName) {
            this.evalResourceName = evalResourceName;
            return this;
        }

        public final void setEvalResourceName(String evalResourceName) {
            this.evalResourceName = evalResourceName;
        }

        public final String getEvalDecision() {
            return this.evalDecision;
        }

        @Override
        public final Builder evalDecision(String evalDecision) {
            this.evalDecision = evalDecision;
            return this;
        }

        @Override
        public final Builder evalDecision(PolicyEvaluationDecisionType evalDecision) {
            this.evalDecision(evalDecision.toString());
            return this;
        }

        public final void setEvalDecision(String evalDecision) {
            this.evalDecision = evalDecision;
        }

        public final void setEvalDecision(PolicyEvaluationDecisionType evalDecision) {
            this.evalDecision(evalDecision.toString());
        }

        public final Collection<Statement> getMatchedStatements() {
            return this.matchedStatements;
        }

        @Override
        public final Builder matchedStatements(Collection<Statement> matchedStatements) {
            this.matchedStatements = StatementListTypeCopier.copy(matchedStatements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedStatements(Statement ... matchedStatements) {
            if (this.matchedStatements == null) {
                this.matchedStatements = new SdkInternalList(matchedStatements.length);
            }
            for (Statement e : matchedStatements) {
                this.matchedStatements.add(e);
            }
            return this;
        }

        public final void setMatchedStatements(Collection<Statement> matchedStatements) {
            this.matchedStatements = StatementListTypeCopier.copy(matchedStatements);
        }

        @SafeVarargs
        public final void setMatchedStatements(Statement ... matchedStatements) {
            if (this.matchedStatements == null) {
                this.matchedStatements = new SdkInternalList(matchedStatements.length);
            }
            for (Statement e : matchedStatements) {
                this.matchedStatements.add(e);
            }
        }

        public final Collection<String> getMissingContextValues() {
            return this.missingContextValues;
        }

        @Override
        public final Builder missingContextValues(Collection<String> missingContextValues) {
            this.missingContextValues = ContextKeyNamesResultListTypeCopier.copy(missingContextValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingContextValues(String ... missingContextValues) {
            if (this.missingContextValues == null) {
                this.missingContextValues = new SdkInternalList(missingContextValues.length);
            }
            for (String e : missingContextValues) {
                this.missingContextValues.add(e);
            }
            return this;
        }

        public final void setMissingContextValues(Collection<String> missingContextValues) {
            this.missingContextValues = ContextKeyNamesResultListTypeCopier.copy(missingContextValues);
        }

        @SafeVarargs
        public final void setMissingContextValues(String ... missingContextValues) {
            if (this.missingContextValues == null) {
                this.missingContextValues = new SdkInternalList(missingContextValues.length);
            }
            for (String e : missingContextValues) {
                this.missingContextValues.add(e);
            }
        }

        public final OrganizationsDecisionDetail getOrganizationsDecisionDetail() {
            return this.organizationsDecisionDetail;
        }

        @Override
        public final Builder organizationsDecisionDetail(OrganizationsDecisionDetail organizationsDecisionDetail) {
            this.organizationsDecisionDetail = organizationsDecisionDetail;
            return this;
        }

        public final void setOrganizationsDecisionDetail(OrganizationsDecisionDetail organizationsDecisionDetail) {
            this.organizationsDecisionDetail = organizationsDecisionDetail;
        }

        public final Map<String, String> getEvalDecisionDetails() {
            return this.evalDecisionDetails;
        }

        @Override
        public final Builder evalDecisionDetails(Map<String, String> evalDecisionDetails) {
            this.evalDecisionDetails = EvalDecisionDetailsTypeCopier.copy(evalDecisionDetails);
            return this;
        }

        public final void setEvalDecisionDetails(Map<String, String> evalDecisionDetails) {
            this.evalDecisionDetails = EvalDecisionDetailsTypeCopier.copy(evalDecisionDetails);
        }

        public final Collection<ResourceSpecificResult> getResourceSpecificResults() {
            return this.resourceSpecificResults;
        }

        @Override
        public final Builder resourceSpecificResults(Collection<ResourceSpecificResult> resourceSpecificResults) {
            this.resourceSpecificResults = ResourceSpecificResultListTypeCopier.copy(resourceSpecificResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSpecificResults(ResourceSpecificResult ... resourceSpecificResults) {
            if (this.resourceSpecificResults == null) {
                this.resourceSpecificResults = new SdkInternalList(resourceSpecificResults.length);
            }
            for (ResourceSpecificResult e : resourceSpecificResults) {
                this.resourceSpecificResults.add(e);
            }
            return this;
        }

        public final void setResourceSpecificResults(Collection<ResourceSpecificResult> resourceSpecificResults) {
            this.resourceSpecificResults = ResourceSpecificResultListTypeCopier.copy(resourceSpecificResults);
        }

        @SafeVarargs
        public final void setResourceSpecificResults(ResourceSpecificResult ... resourceSpecificResults) {
            if (this.resourceSpecificResults == null) {
                this.resourceSpecificResults = new SdkInternalList(resourceSpecificResults.length);
            }
            for (ResourceSpecificResult e : resourceSpecificResults) {
                this.resourceSpecificResults.add(e);
            }
        }

        public EvaluationResult build() {
            return new EvaluationResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EvaluationResult> {
        public Builder evalActionName(String var1);

        public Builder evalResourceName(String var1);

        public Builder evalDecision(String var1);

        public Builder evalDecision(PolicyEvaluationDecisionType var1);

        public Builder matchedStatements(Collection<Statement> var1);

        public Builder matchedStatements(Statement ... var1);

        public Builder missingContextValues(Collection<String> var1);

        public Builder missingContextValues(String ... var1);

        public Builder organizationsDecisionDetail(OrganizationsDecisionDetail var1);

        public Builder evalDecisionDetails(Map<String, String> var1);

        public Builder resourceSpecificResults(Collection<ResourceSpecificResult> var1);

        public Builder resourceSpecificResults(ResourceSpecificResult ... var1);
    }
}

