/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.policybuilder.iam.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.policybuilder.iam.IamCondition;
import software.amazon.awssdk.policybuilder.iam.IamPolicy;
import software.amazon.awssdk.policybuilder.iam.IamPolicyReader;
import software.amazon.awssdk.policybuilder.iam.IamPrincipal;
import software.amazon.awssdk.policybuilder.iam.IamStatement;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultIamPolicyReader
implements IamPolicyReader {
    private static final JsonNodeParser JSON_NODE_PARSER = JsonNodeParser.create();

    @Override
    public IamPolicy read(String policy) {
        return this.read(policy.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public IamPolicy read(byte[] policy) {
        return this.read(new ByteArrayInputStream(policy));
    }

    @Override
    public IamPolicy read(InputStream policy) {
        return this.readPolicy(JSON_NODE_PARSER.parse(policy));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return 0;
    }

    private IamPolicy readPolicy(JsonNode policyNode) {
        Map<String, JsonNode> policyObject = this.expectObject(policyNode, "Policy did not start with {");
        return (IamPolicy)IamPolicy.builder().version(this.getString(policyObject, "Version")).id(this.getString(policyObject, "Id")).statements(this.readStatements(policyObject.get("Statement"))).build();
    }

    private List<IamStatement> readStatements(JsonNode statementsNode) {
        if (statementsNode == null) {
            return null;
        }
        if (statementsNode.isArray()) {
            return statementsNode.asArray().stream().map(n -> this.expectObject((JsonNode)n, "Statement entry")).map(this::readStatement).collect(Collectors.toList());
        }
        if (statementsNode.isObject()) {
            return Collections.singletonList(this.readStatement(statementsNode.asObject()));
        }
        throw new IllegalArgumentException("Statement was not an array or object.");
    }

    private IamStatement readStatement(Map<String, JsonNode> statementObject) {
        return (IamStatement)IamStatement.builder().sid(this.getString(statementObject, "Sid")).effect(this.getString(statementObject, "Effect")).principals(this.readPrincipals(statementObject, "Principal")).notPrincipals(this.readPrincipals(statementObject, "NotPrincipal")).actionIds(this.readStringArray(statementObject, "Action")).notActionIds(this.readStringArray(statementObject, "NotAction")).resourceIds(this.readStringArray(statementObject, "Resource")).notResourceIds(this.readStringArray(statementObject, "NotResource")).conditions(this.readConditions(statementObject.get("Condition"))).build();
    }

    private List<IamPrincipal> readPrincipals(Map<String, JsonNode> statementObject, String name) {
        JsonNode principalsNode = statementObject.get(name);
        if (principalsNode == null) {
            return null;
        }
        if (principalsNode.isString() && principalsNode.asString().equals(IamPrincipal.ALL.id())) {
            return Collections.singletonList(IamPrincipal.ALL);
        }
        if (principalsNode.isObject()) {
            ArrayList<IamPrincipal> result = new ArrayList<IamPrincipal>();
            principalsNode.asObject().forEach((id, value) -> result.add(IamPrincipal.create(id, this.expectString((JsonNode)value, name + " entry value"))));
            return result;
        }
        throw new IllegalArgumentException(name + " was not \"" + IamPrincipal.ALL.id() + "\" or an object");
    }

    private List<IamCondition> readConditions(JsonNode conditionNode) {
        if (conditionNode == null) {
            return null;
        }
        Map<String, JsonNode> conditionObject = this.expectObject(conditionNode, "Condition");
        ArrayList<IamCondition> result = new ArrayList<IamCondition>();
        conditionObject.forEach((operator, keyValueNode) -> {
            Map<String, JsonNode> keyValueObject = this.expectObject((JsonNode)keyValueNode, "Condition key");
            keyValueObject.forEach((key, value) -> {
                if (value.isString()) {
                    result.add(IamCondition.create(operator, key, value.asString()));
                } else if (value.isArray()) {
                    List<String> values = value.asArray().stream().map(valueNode -> this.expectString((JsonNode)valueNode, "Condition values entry")).collect(Collectors.toList());
                    result.addAll(IamCondition.createAll(operator, key, values));
                }
            });
        });
        return result;
    }

    private List<String> readStringArray(Map<String, JsonNode> statementObject, String nodeKey) {
        JsonNode node = statementObject.get(nodeKey);
        if (node == null) {
            return null;
        }
        if (node.isString()) {
            return Collections.singletonList(node.asString());
        }
        if (node.isArray()) {
            return node.asArray().stream().map(n -> this.expectString((JsonNode)n, nodeKey + " entry")).collect(Collectors.toList());
        }
        throw new IllegalArgumentException(nodeKey + " was not an array or string");
    }

    private String getString(Map<String, JsonNode> object, String key) {
        JsonNode node = object.get(key);
        if (node == null) {
            return null;
        }
        return this.expectString(node, key);
    }

    private String expectString(JsonNode node, String name) {
        Validate.isTrue((boolean)node.isString(), (String)"%s was not a string", (Object[])new Object[]{name});
        return node.asString();
    }

    private Map<String, JsonNode> expectObject(JsonNode node, String name) {
        Validate.isTrue((boolean)node.isObject(), (String)"%s was not an object", (Object[])new Object[]{name});
        return node.asObject();
    }
}

