/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import software.amazon.awssdk.http.HttpTestUtils;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;

public abstract class SdkAsyncHttpClientH1TestSuite {
    private Server server;
    private SdkAsyncHttpClient client;

    protected abstract SdkAsyncHttpClient setupClient();

    @BeforeEach
    public void setup() throws Exception {
        this.server = new Server();
        this.server.init();
        this.client = this.setupClient();
    }

    @AfterEach
    public void teardown() throws InterruptedException {
        if (this.server != null) {
            this.server.shutdown();
        }
        if (this.client != null) {
            this.client.close();
        }
        this.server = null;
    }

    @Test
    public void connectionReceiveServerErrorStatusShouldNotReuseConnection() {
        this.server.return500OnFirstRequest = true;
        this.server.closeConnection = false;
        HttpTestUtils.sendGetRequest(this.server.port(), this.client).join();
        HttpTestUtils.sendGetRequest(this.server.port(), this.client).join();
        AssertionsForInterfaceTypes.assertThat((int)this.server.channels.size()).isEqualTo(2);
    }

    @Test
    public void connectionReceiveOkStatusShouldReuseConnection() throws Exception {
        this.server.return500OnFirstRequest = false;
        this.server.closeConnection = false;
        HttpTestUtils.sendGetRequest(this.server.port(), this.client).join();
        Thread.sleep(100L);
        HttpTestUtils.sendGetRequest(this.server.port(), this.client).join();
        AssertionsForInterfaceTypes.assertThat((int)this.server.channels.size()).isEqualTo(1);
    }

    @Test
    public void connectionReceiveCloseHeaderShouldNotReuseConnection() throws InterruptedException {
        this.server.return500OnFirstRequest = false;
        this.server.closeConnection = true;
        HttpTestUtils.sendGetRequest(this.server.port(), this.client).join();
        Thread.sleep(1000L);
        HttpTestUtils.sendGetRequest(this.server.port(), this.client).join();
        AssertionsForInterfaceTypes.assertThat((int)this.server.channels.size()).isEqualTo(2);
    }

    @Test
    public void headRequestResponsesHaveNoPayload() {
        byte[] responseData = HttpTestUtils.sendHeadRequest(this.server.port(), this.client).join();
        AssertionsForInterfaceTypes.assertThat((byte[])responseData).isNull();
    }

    @Test
    public void naughtyHeaderCharactersDoNotGetToServer() {
        String naughtyHeader = "foo\r\nbar";
        AssertionsForClassTypes.assertThatThrownBy(() -> HttpTestUtils.sendRequest(this.client, SdkHttpFullRequest.builder().uri(URI.create("https://localhost:" + this.server.port())).method(SdkHttpMethod.POST).appendHeader("h", naughtyHeader).build()).join()).hasCauseInstanceOf(Exception.class);
    }

    @Test
    public void connectionsArePooledByHostAndPort() throws InterruptedException {
        HttpTestUtils.sendRequest(this.client, SdkHttpFullRequest.builder().uri(URI.create("https://127.0.0.1:" + this.server.port() + "/foo?foo")).method(SdkHttpMethod.GET).build()).join();
        Thread.sleep(1000L);
        HttpTestUtils.sendRequest(this.client, SdkHttpFullRequest.builder().uri(URI.create("https://127.0.0.1:" + this.server.port() + "/bar?bar")).method(SdkHttpMethod.GET).build()).join();
        AssertionsForInterfaceTypes.assertThat((int)this.server.channels.size()).isEqualTo(1);
    }

    private static class Server
    extends ChannelInitializer<Channel> {
        private static final byte[] CONTENT = "helloworld".getBytes(StandardCharsets.UTF_8);
        private ServerBootstrap bootstrap;
        private ServerSocketChannel serverSock;
        private List<Channel> channels = new ArrayList<Channel>();
        private final NioEventLoopGroup group = new NioEventLoopGroup();
        private SslContext sslCtx;
        private boolean return500OnFirstRequest;
        private boolean closeConnection;

        private Server() {
        }

        public void init() throws Exception {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            this.sslCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
            this.bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).group((EventLoopGroup)this.group).childHandler((ChannelHandler)this);
            this.serverSock = (ServerSocketChannel)this.bootstrap.bind(0).sync().channel();
        }

        public void shutdown() throws InterruptedException {
            this.group.shutdownGracefully().await();
            this.serverSock.close();
        }

        public int port() {
            return this.serverSock.localAddress().getPort();
        }

        protected void initChannel(Channel ch) {
            this.channels.add(ch);
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
            pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
            pipeline.addLast(new ChannelHandler[]{new BehaviorTestChannelHandler()});
        }

        private class BehaviorTestChannelHandler
        extends ChannelDuplexHandler {
            private BehaviorTestChannelHandler() {
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                if (msg instanceof HttpRequest) {
                    HttpResponseStatus status = ctx.channel().equals(Server.this.channels.get(0)) && Server.this.return500OnFirstRequest ? HttpResponseStatus.INTERNAL_SERVER_ERROR : HttpResponseStatus.OK;
                    DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.wrappedBuffer((byte[])CONTENT));
                    response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN).setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
                    if (Server.this.closeConnection) {
                        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                    }
                    ctx.writeAndFlush((Object)response);
                }
            }
        }
    }
}

