/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.async.SimpleSubscriber;
import software.amazon.awssdk.metrics.MetricCollector;

public final class RecordingResponseHandler
implements SdkAsyncHttpResponseHandler {
    private final List<SdkHttpResponse> responses = new ArrayList<SdkHttpResponse>();
    private final StringBuilder bodyParts = new StringBuilder();
    private final CompletableFuture<Void> completeFuture = new CompletableFuture();
    private final MetricCollector collector = MetricCollector.create((String)"test");

    public void onHeaders(SdkHttpResponse response) {
        this.responses.add(response);
    }

    public void onStream(Publisher<ByteBuffer> publisher) {
        publisher.subscribe((Subscriber)new SimpleSubscriber(byteBuffer -> {
            byte[] b = new byte[byteBuffer.remaining()];
            byteBuffer.duplicate().get(b);
            this.bodyParts.append(new String(b, StandardCharsets.UTF_8));
        }){

            public void onError(Throwable t) {
                RecordingResponseHandler.this.completeFuture.completeExceptionally(t);
            }

            public void onComplete() {
                RecordingResponseHandler.this.completeFuture.complete(null);
            }
        });
    }

    public void onError(Throwable error) {
        this.completeFuture.completeExceptionally(error);
    }

    public String fullResponseAsString() {
        return this.bodyParts.toString();
    }

    public List<SdkHttpResponse> responses() {
        return this.responses;
    }

    public StringBuilder bodyParts() {
        return this.bodyParts;
    }

    public CompletableFuture<Void> completeFuture() {
        return this.completeFuture;
    }

    public MetricCollector collector() {
        return this.collector;
    }
}

