/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.net.ssl.SSLHandshakeException;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkRequestContext;
import software.amazon.awssdk.utils.IoUtils;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class SdkHttpClientTestSuite {
    @Rule
    public WireMockRule mockServer = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort());
    @Mock
    private SdkRequestContext requestContext;

    @Test
    public void supportsAllResponseCodes() throws Exception {
        SdkHttpClient client = this.createSdkHttpClient();
        this.testForResponseCode(client, 200);
        this.testForResponseCode(client, 202);
        this.testForResponseCode(client, 403);
        this.testForResponseCode(client, 301);
        this.testForResponseCode(client, 302);
        this.testForResponseCode(client, 500);
    }

    @Test
    public void validatesHttpsCertificateIssuer() throws Exception {
        SdkHttpClient client = this.createSdkHttpClient();
        SdkHttpFullRequest request = this.mockSdkRequest("https://localhost:" + this.mockServer.httpsPort());
        Assertions.assertThatThrownBy(() -> client.prepareRequest(request, this.requestContext).call()).isInstanceOf(SSLHandshakeException.class);
    }

    private void testForResponseCode(SdkHttpClient client, int returnCode) throws Exception {
        this.stubForMockRequest(returnCode);
        SdkHttpFullRequest request = this.mockSdkRequest("http://localhost:" + this.mockServer.port());
        SdkHttpFullResponse response = (SdkHttpFullResponse)client.prepareRequest(request, this.requestContext).call();
        this.validateResponse(response, returnCode);
    }

    private void stubForMockRequest(int returnCode) {
        WireMock.stubFor((MappingBuilder)WireMock.any((UrlMatchingStrategy)WireMock.urlPathEqualTo((String)"/")).willReturn(WireMock.aResponse().withStatus(returnCode).withHeader("Some-Header", "With Value").withBody("hello")));
    }

    private void validateResponse(SdkHttpFullResponse response, int returnCode) throws IOException {
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlMatching((String)"/")).withHeader("Host", WireMock.containing((String)"localhost")).withHeader("User-Agent", WireMock.equalTo((String)"hello-world!")).withRequestBody(WireMock.equalTo((String)"Body")));
        Assertions.assertThat((String)IoUtils.toString((InputStream)response.content().orElse(null))).isEqualTo((Object)"hello");
        Assertions.assertThat((Optional)response.firstMatchingHeader("Some-Header")).contains((Object)"With Value");
        Assertions.assertThat((int)response.statusCode()).isEqualTo(returnCode);
        this.mockServer.resetMappings();
    }

    private SdkHttpFullRequest mockSdkRequest(String uriString) {
        URI uri = URI.create(uriString);
        return (SdkHttpFullRequest)SdkHttpFullRequest.builder().host(uri.getHost()).protocol(uri.getScheme()).port(Integer.valueOf(uri.getPort())).method(SdkHttpMethod.POST).header("Host", uri.getHost()).header("User-Agent", "hello-world!").content((InputStream)new ByteArrayInputStream("Body".getBytes(StandardCharsets.UTF_8))).build();
    }

    protected final SdkHttpClient createSdkHttpClient() {
        return this.createSdkHttpClient(new SdkHttpClientOptions());
    }

    protected abstract SdkHttpClient createSdkHttpClient(SdkHttpClientOptions var1);

    protected static final class SdkHttpClientOptions {
        protected SdkHttpClientOptions() {
        }
    }
}

