/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.time.Duration;
import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.utils.AttributeMap;

@SdkProtectedApi
public final class SdkHttpConfigurationOption<T>
extends AttributeMap.Key<T> {
    public static final SdkHttpConfigurationOption<Duration> SOCKET_TIMEOUT = new SdkHttpConfigurationOption<Duration>("SocketTimeout", Duration.class);
    public static final SdkHttpConfigurationOption<Duration> CONNECTION_TIMEOUT = new SdkHttpConfigurationOption<Duration>("ConnectionTimeout", Duration.class);
    public static final SdkHttpConfigurationOption<Integer> MAX_CONNECTIONS = new SdkHttpConfigurationOption<Integer>("MaxConnections", Integer.class);
    @ReviewBeforeRelease(value="This does not appear to be needed anymore for S3")
    public static final SdkHttpConfigurationOption<Boolean> USE_STRICT_HOSTNAME_VERIFICATION = new SdkHttpConfigurationOption<Boolean>("UseStrictHostnameVerification", Boolean.class);
    private static final Duration DEFAULT_SOCKET_TIMEOUT = Duration.ofSeconds(50L);
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(10L);
    private static final int DEFAULT_MAX_CONNECTIONS = 50;
    private static final Boolean DEFAULT_USE_STRICT_HOSTNAME_VERIFICATION = Boolean.TRUE;
    @ReviewBeforeRelease(value="Confirm defaults")
    public static final AttributeMap GLOBAL_HTTP_DEFAULTS = AttributeMap.builder().put(SOCKET_TIMEOUT, (Object)DEFAULT_SOCKET_TIMEOUT).put(CONNECTION_TIMEOUT, (Object)DEFAULT_CONNECTION_TIMEOUT).put(MAX_CONNECTIONS, (Object)50).put(USE_STRICT_HOSTNAME_VERIFICATION, (Object)DEFAULT_USE_STRICT_HOSTNAME_VERIFICATION).build();
    private final String name;

    private SdkHttpConfigurationOption(String name, Class<T> clzz) {
        super(clzz);
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

