/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
class DefaultSdkHttpFullRequest
implements SdkHttpFullRequest {
    private final Map<String, List<String>> headers;
    private final String resourcePath;
    private final Map<String, List<String>> queryParameters;
    private final URI endpoint;
    private final SdkHttpMethod httpMethod;
    private final InputStream content;

    private DefaultSdkHttpFullRequest(Builder builder) {
        this.headers = CollectionUtils.deepUnmodifiableMap((Map)builder.headers, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
        this.queryParameters = CollectionUtils.deepUnmodifiableMap((Map)builder.queryParameters, () -> new LinkedHashMap());
        this.resourcePath = builder.resourcePath;
        this.endpoint = builder.endpoint;
        this.httpMethod = builder.httpMethod;
        this.content = builder.content;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public Collection<String> getValuesForHeader(String header) {
        return this.headers.getOrDefault(header, Collections.emptyList());
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public Map<String, List<String>> getParameters() {
        return this.queryParameters;
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public SdkHttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public InputStream getContent() {
        return this.content;
    }

    public Builder toBuilder() {
        return ((Builder)((Builder)new Builder().headers((Map)this.headers)).resourcePath(this.resourcePath).httpMethod(this.httpMethod).endpoint(this.endpoint).queryParameters((Map)this.queryParameters)).content(this.content);
    }

    static final class Builder
    implements SdkHttpFullRequest.Builder {
        private Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private String resourcePath;
        @ReviewBeforeRelease(value="Do we need linked hash map here?")
        private Map<String, List<String>> queryParameters = new LinkedHashMap<String, List<String>>();
        private URI endpoint;
        private SdkHttpMethod httpMethod;
        private InputStream content;

        Builder() {
        }

        @Override
        public Builder header(String key, List<String> values) {
            this.headers.put(key, new ArrayList<String>(values));
            return this;
        }

        @Override
        public Builder headers(Map<String, List<String>> headers) {
            this.headers = CollectionUtils.deepCopyMap(headers);
            return this;
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return CollectionUtils.deepUnmodifiableMap(this.headers);
        }

        @Override
        public Builder resourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        @Override
        public String getResourcePath() {
            return this.resourcePath;
        }

        @Override
        public Builder queryParameter(String paramName, List<String> paramValues) {
            this.queryParameters.put(paramName, new ArrayList<String>(paramValues));
            return this;
        }

        @Override
        public Builder queryParameters(Map<String, List<String>> queryParameters) {
            this.queryParameters = CollectionUtils.deepCopyMap(queryParameters, () -> new LinkedHashMap());
            return this;
        }

        @Override
        public SdkHttpFullRequest.Builder removeQueryParameter(String paramName) {
            this.queryParameters.remove(paramName);
            return this;
        }

        @Override
        public SdkHttpFullRequest.Builder clearQueryParameters() {
            this.queryParameters.clear();
            return this;
        }

        @Override
        public Map<String, List<String>> getParameters() {
            return CollectionUtils.deepUnmodifiableMap(this.queryParameters);
        }

        @Override
        public Builder endpoint(URI endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public URI getEndpoint() {
            return this.endpoint;
        }

        @Override
        public Builder httpMethod(SdkHttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Override
        public SdkHttpMethod getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public Builder content(InputStream content) {
            this.content = content;
            return this;
        }

        @Override
        public InputStream getContent() {
            return this.content;
        }

        public DefaultSdkHttpFullRequest build() {
            return new DefaultSdkHttpFullRequest(this);
        }

        @ReviewBeforeRelease(value="This is why we shouldn't extend the request in the builder.")
        public SdkHttpFullRequest.Builder toBuilder() {
            throw new UnsupportedOperationException();
        }
    }
}

