/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.SdkHttpFullRequest;

@SdkPublicApi
public final class ExecuteRequest {
    private final SdkHttpFullRequest request;
    private final boolean isFullDuplex;

    private ExecuteRequest(BuilderImpl builder) {
        this.request = builder.request;
        this.isFullDuplex = builder.isFullDuplex;
    }

    public SdkHttpFullRequest httpRequest() {
        return this.request;
    }

    public boolean fullDuplex() {
        return this.isFullDuplex;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private static class BuilderImpl
    implements Builder {
        private SdkHttpFullRequest request;
        private boolean isFullDuplex;

        private BuilderImpl() {
        }

        @Override
        public Builder request(SdkHttpFullRequest request) {
            this.request = request;
            return this;
        }

        @Override
        public Builder fullDuplex(boolean fullDuplex) {
            this.isFullDuplex = fullDuplex;
            return this;
        }

        @Override
        public ExecuteRequest build() {
            return new ExecuteRequest(this);
        }
    }

    public static interface Builder {
        public Builder request(SdkHttpFullRequest var1);

        public Builder fullDuplex(boolean var1);

        public ExecuteRequest build();
    }
}

