/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
@Immutable
final class DefaultSdkHttpFullRequest
implements SdkHttpFullRequest {
    private final String protocol;
    private final String host;
    private final Integer port;
    private final String path;
    private final Map<String, List<String>> queryParameters;
    private final SdkHttpMethod httpMethod;
    private final Map<String, List<String>> headers;
    private final ContentStreamProvider contentStreamProvider;

    private DefaultSdkHttpFullRequest(Builder builder) {
        this.protocol = this.standardizeProtocol(builder.protocol);
        this.host = (String)Validate.paramNotNull((Object)builder.host, (String)"host");
        this.port = this.standardizePort(builder.port);
        this.path = this.standardizePath(builder.path);
        this.queryParameters = CollectionUtils.deepUnmodifiableMap((Map)builder.queryParameters, () -> new LinkedHashMap());
        this.httpMethod = (SdkHttpMethod)((Object)Validate.paramNotNull((Object)((Object)builder.httpMethod), (String)"method"));
        this.headers = CollectionUtils.deepUnmodifiableMap((Map)builder.headers, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
        this.contentStreamProvider = builder.contentStreamProvider;
    }

    private String standardizeProtocol(String protocol) {
        Validate.paramNotNull((Object)protocol, (String)"protocol");
        String standardizedProtocol = StringUtils.lowerCase((String)protocol);
        Validate.isTrue((standardizedProtocol.equals("http") || standardizedProtocol.equals("https") ? 1 : 0) != 0, (String)"Protocol must be 'http' or 'https', but was %s", (Object[])new Object[]{protocol});
        return standardizedProtocol;
    }

    private String standardizePath(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return "";
        }
        StringBuilder standardizedPath = new StringBuilder();
        if (!path.startsWith("/")) {
            standardizedPath.append('/');
        }
        standardizedPath.append(path);
        return standardizedPath.toString();
    }

    private Integer standardizePort(Integer port) {
        Validate.isTrue((port == null || port >= -1 ? 1 : 0) != 0, (String)"Port must be positive (or null/-1 to indicate no port), but was '%s'", (Object[])new Object[]{port});
        if (port != null && port == -1) {
            return null;
        }
        return port;
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public int port() {
        return Optional.ofNullable(this.port).orElseGet(() -> SdkHttpUtils.standardPort((String)this.protocol()));
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    @Override
    public String encodedPath() {
        return this.path;
    }

    @Override
    public Map<String, List<String>> rawQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public SdkHttpMethod method() {
        return this.httpMethod;
    }

    @Override
    public Optional<ContentStreamProvider> contentStreamProvider() {
        return Optional.ofNullable(this.contentStreamProvider);
    }

    public SdkHttpFullRequest.Builder toBuilder() {
        return new Builder().protocol(this.protocol).host(this.host).port(this.port).encodedPath(this.path).rawQueryParameters(this.queryParameters).method(this.httpMethod).headers(this.headers).contentStreamProvider(this.contentStreamProvider);
    }

    public String toString() {
        return ToString.builder((String)"DefaultSdkHttpFullRequest").add("httpMethod", (Object)this.httpMethod).add("protocol", (Object)this.protocol).add("host", (Object)this.host).add("port", (Object)this.port).add("encodedPath", (Object)this.path).add("headers", this.headers.keySet()).add("queryParameters", this.queryParameters.keySet()).build();
    }

    static final class Builder
    implements SdkHttpFullRequest.Builder {
        private String protocol;
        private String host;
        private Integer port;
        private String path;
        private Map<String, List<String>> queryParameters = new LinkedHashMap<String, List<String>>();
        private SdkHttpMethod httpMethod;
        private Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        private ContentStreamProvider contentStreamProvider;

        Builder() {
        }

        @Override
        public String protocol() {
            return this.protocol;
        }

        @Override
        public SdkHttpFullRequest.Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public String host() {
            return this.host;
        }

        @Override
        public SdkHttpFullRequest.Builder host(String host) {
            this.host = host;
            return this;
        }

        @Override
        public Integer port() {
            return this.port;
        }

        @Override
        public SdkHttpFullRequest.Builder port(Integer port) {
            this.port = port;
            return this;
        }

        @Override
        public Builder encodedPath(String path) {
            this.path = path;
            return this;
        }

        @Override
        public String encodedPath() {
            return this.path;
        }

        @Override
        public Builder putRawQueryParameter(String paramName, List<String> paramValues) {
            this.queryParameters.put(paramName, new ArrayList<String>(paramValues));
            return this;
        }

        @Override
        public SdkHttpFullRequest.Builder appendRawQueryParameter(String paramName, String paramValue) {
            this.queryParameters.computeIfAbsent(paramName, k -> new ArrayList()).add(paramValue);
            return this;
        }

        @Override
        public Builder rawQueryParameters(Map<String, List<String>> queryParameters) {
            this.queryParameters = CollectionUtils.deepCopyMap(queryParameters, () -> new LinkedHashMap());
            return this;
        }

        @Override
        public Builder removeQueryParameter(String paramName) {
            this.queryParameters.remove(paramName);
            return this;
        }

        @Override
        public Builder clearQueryParameters() {
            this.queryParameters.clear();
            return this;
        }

        @Override
        public Map<String, List<String>> rawQueryParameters() {
            return CollectionUtils.deepUnmodifiableMap(this.queryParameters, () -> new LinkedHashMap());
        }

        @Override
        public Builder method(SdkHttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Override
        public SdkHttpMethod method() {
            return this.httpMethod;
        }

        @Override
        public Builder putHeader(String headerName, List<String> headerValues) {
            this.headers.put(headerName, new ArrayList<String>(headerValues));
            return this;
        }

        @Override
        public SdkHttpFullRequest.Builder appendHeader(String headerName, String headerValue) {
            this.headers.computeIfAbsent(headerName, k -> new ArrayList()).add(headerValue);
            return this;
        }

        @Override
        public Builder headers(Map<String, List<String>> headers) {
            this.headers = CollectionUtils.deepCopyMap(headers);
            return this;
        }

        @Override
        public SdkHttpFullRequest.Builder removeHeader(String headerName) {
            this.headers.remove(headerName);
            return this;
        }

        @Override
        public SdkHttpFullRequest.Builder clearHeaders() {
            this.headers.clear();
            return this;
        }

        @Override
        public Map<String, List<String>> headers() {
            return CollectionUtils.deepUnmodifiableMap(this.headers);
        }

        @Override
        public Builder contentStreamProvider(ContentStreamProvider contentStreamProvider) {
            this.contentStreamProvider = contentStreamProvider;
            return this;
        }

        @Override
        public ContentStreamProvider contentStreamProvider() {
            return this.contentStreamProvider;
        }

        public DefaultSdkHttpFullRequest build() {
            return new DefaultSdkHttpFullRequest(this);
        }
    }
}

