/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EventStatusCode {
    OPEN("open"),
    CLOSED("closed"),
    UPCOMING("upcoming"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EventStatusCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EventStatusCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventStatusCode> knownValues() {
        return Stream.of(EventStatusCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

