/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EventTypeCategory {
    ISSUE("issue"),
    ACCOUNT_NOTIFICATION("accountNotification"),
    SCHEDULED_CHANGE("scheduledChange"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EventTypeCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventTypeCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EventTypeCategory.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventTypeCategory> knownValues() {
        return Stream.of(EventTypeCategory.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

