/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.EventTypeActionability;
import software.amazon.awssdk.services.health.model.EventTypeCategory;
import software.amazon.awssdk.services.health.model.EventTypePersona;
import software.amazon.awssdk.services.health.model.EventTypePersonaListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventType> {
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("service").getter(EventType.getter(EventType::service)).setter(EventType.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("code").getter(EventType.getter(EventType::code)).setter(EventType.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("category").getter(EventType.getter(EventType::categoryAsString)).setter(EventType.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final SdkField<String> ACTIONABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionability").getter(EventType.getter(EventType::actionabilityAsString)).setter(EventType.setter(Builder::actionability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionability").build()}).build();
    private static final SdkField<List<String>> PERSONAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("personas").getter(EventType.getter(EventType::personasAsStrings)).setter(EventType.setter(Builder::personasWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("personas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, CODE_FIELD, CATEGORY_FIELD, ACTIONABILITY_FIELD, PERSONAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String service;
    private final String code;
    private final String category;
    private final String actionability;
    private final List<String> personas;

    private EventType(BuilderImpl builder) {
        this.service = builder.service;
        this.code = builder.code;
        this.category = builder.category;
        this.actionability = builder.actionability;
        this.personas = builder.personas;
    }

    public final String service() {
        return this.service;
    }

    public final String code() {
        return this.code;
    }

    public final EventTypeCategory category() {
        return EventTypeCategory.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final EventTypeActionability actionability() {
        return EventTypeActionability.fromValue(this.actionability);
    }

    public final String actionabilityAsString() {
        return this.actionability;
    }

    public final List<EventTypePersona> personas() {
        return EventTypePersonaListCopier.copyStringToEnum(this.personas);
    }

    public final boolean hasPersonas() {
        return this.personas != null && !(this.personas instanceof SdkAutoConstructList);
    }

    public final List<String> personasAsStrings() {
        return this.personas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPersonas() ? this.personasAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventType)) {
            return false;
        }
        EventType other = (EventType)obj;
        return Objects.equals(this.service(), other.service()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.actionabilityAsString(), other.actionabilityAsString()) && this.hasPersonas() == other.hasPersonas() && Objects.equals(this.personasAsStrings(), other.personasAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"EventType").add("Service", (Object)this.service()).add("Code", (Object)this.code()).add("Category", (Object)this.categoryAsString()).add("Actionability", (Object)this.actionabilityAsString()).add("Personas", this.hasPersonas() ? this.personasAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "actionability": {
                return Optional.ofNullable(clazz.cast(this.actionabilityAsString()));
            }
            case "personas": {
                return Optional.ofNullable(clazz.cast(this.personasAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("service", SERVICE_FIELD);
        map.put("code", CODE_FIELD);
        map.put("category", CATEGORY_FIELD);
        map.put("actionability", ACTIONABILITY_FIELD);
        map.put("personas", PERSONAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventType, T> g) {
        return obj -> g.apply((EventType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String service;
        private String code;
        private String category;
        private String actionability;
        private List<String> personas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventType model) {
            this.service(model.service);
            this.code(model.code);
            this.category(model.category);
            this.actionability(model.actionability);
            this.personasWithStrings(model.personas);
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(EventTypeCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getActionability() {
            return this.actionability;
        }

        public final void setActionability(String actionability) {
            this.actionability = actionability;
        }

        @Override
        public final Builder actionability(String actionability) {
            this.actionability = actionability;
            return this;
        }

        @Override
        public final Builder actionability(EventTypeActionability actionability) {
            this.actionability(actionability == null ? null : actionability.toString());
            return this;
        }

        public final Collection<String> getPersonas() {
            if (this.personas instanceof SdkAutoConstructList) {
                return null;
            }
            return this.personas;
        }

        public final void setPersonas(Collection<String> personas) {
            this.personas = EventTypePersonaListCopier.copy(personas);
        }

        @Override
        public final Builder personasWithStrings(Collection<String> personas) {
            this.personas = EventTypePersonaListCopier.copy(personas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personasWithStrings(String ... personas) {
            this.personasWithStrings(Arrays.asList(personas));
            return this;
        }

        @Override
        public final Builder personas(Collection<EventTypePersona> personas) {
            this.personas = EventTypePersonaListCopier.copyEnumToString(personas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personas(EventTypePersona ... personas) {
            this.personas(Arrays.asList(personas));
            return this;
        }

        public EventType build() {
            return new EventType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventType> {
        public Builder service(String var1);

        public Builder code(String var1);

        public Builder category(String var1);

        public Builder category(EventTypeCategory var1);

        public Builder actionability(String var1);

        public Builder actionability(EventTypeActionability var1);

        public Builder personasWithStrings(Collection<String> var1);

        public Builder personasWithStrings(String ... var1);

        public Builder personas(Collection<EventTypePersona> var1);

        public Builder personas(EventTypePersona ... var1);
    }
}

