/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventPersona {
    OPERATIONS("OPERATIONS"),
    SECURITY("SECURITY"),
    BILLING("BILLING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventPersona> VALUE_MAP;
    private final String value;

    private EventPersona(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventPersona fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventPersona> knownValues() {
        EnumSet<EventPersona> knownValues = EnumSet.allOf(EventPersona.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventPersona.class, EventPersona::toString);
    }
}

