/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The aggregate results of entities affected by the specified event in your organization. The results are aggregated by
 * the entity status codes for the specified set of accountsIDs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationEntityAggregate implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationEntityAggregate.Builder, OrganizationEntityAggregate> {
    private static final SdkField<String> EVENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventArn").getter(getter(OrganizationEntityAggregate::eventArn)).setter(setter(Builder::eventArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventArn").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("count")
            .getter(getter(OrganizationEntityAggregate::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<Map<String, Integer>> STATUSES_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("statuses")
            .getter(getter(OrganizationEntityAggregate::statusesAsStrings))
            .setter(setter(Builder::statusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<AccountEntityAggregate>> ACCOUNTS_FIELD = SdkField
            .<List<AccountEntityAggregate>> builder(MarshallingType.LIST)
            .memberName("accounts")
            .getter(getter(OrganizationEntityAggregate::accounts))
            .setter(setter(Builder::accounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountEntityAggregate> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountEntityAggregate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ARN_FIELD, COUNT_FIELD,
            STATUSES_FIELD, ACCOUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventArn;

    private final Integer count;

    private final Map<String, Integer> statuses;

    private final List<AccountEntityAggregate> accounts;

    private OrganizationEntityAggregate(BuilderImpl builder) {
        this.eventArn = builder.eventArn;
        this.count = builder.count;
        this.statuses = builder.statuses;
        this.accounts = builder.accounts;
    }

    /**
     * <p>
     * A list of event ARNs (unique identifiers). For example:
     * <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
     * </p>
     * 
     * @return A list of event ARNs (unique identifiers). For example:
     *         <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
     */
    public final String eventArn() {
        return eventArn;
    }

    /**
     * <p>
     * The number of entities for the organization that match the filter criteria for the specified events.
     * </p>
     * 
     * @return The number of entities for the organization that match the filter criteria for the specified events.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The number of affected entities aggregated by the entitiy status codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return The number of affected entities aggregated by the entitiy status codes.
     */
    public final Map<EntityStatusCode, Integer> statuses() {
        return _entityStatusesCopier.copyStringToEnum(statuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the Statuses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatuses() {
        return statuses != null && !(statuses instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The number of affected entities aggregated by the entitiy status codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return The number of affected entities aggregated by the entitiy status codes.
     */
    public final Map<String, Integer> statusesAsStrings() {
        return statuses;
    }

    /**
     * For responses, this returns true if the service returned a value for the Accounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccounts() {
        return accounts != null && !(accounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of entity aggregates for each of the specified accounts in your organization that are affected by a
     * specific event. If there are no <code>awsAccountIds</code> provided in the request, this field will be empty in
     * the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccounts} method.
     * </p>
     * 
     * @return A list of entity aggregates for each of the specified accounts in your organization that are affected by
     *         a specific event. If there are no <code>awsAccountIds</code> provided in the request, this field will be
     *         empty in the response.
     */
    public final List<AccountEntityAggregate> accounts() {
        return accounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventArn());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatuses() ? statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccounts() ? accounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationEntityAggregate)) {
            return false;
        }
        OrganizationEntityAggregate other = (OrganizationEntityAggregate) obj;
        return Objects.equals(eventArn(), other.eventArn()) && Objects.equals(count(), other.count())
                && hasStatuses() == other.hasStatuses() && Objects.equals(statusesAsStrings(), other.statusesAsStrings())
                && hasAccounts() == other.hasAccounts() && Objects.equals(accounts(), other.accounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationEntityAggregate").add("EventArn", eventArn()).add("Count", count())
                .add("Statuses", hasStatuses() ? statusesAsStrings() : null).add("Accounts", hasAccounts() ? accounts() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventArn":
            return Optional.ofNullable(clazz.cast(eventArn()));
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "statuses":
            return Optional.ofNullable(clazz.cast(statusesAsStrings()));
        case "accounts":
            return Optional.ofNullable(clazz.cast(accounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventArn", EVENT_ARN_FIELD);
        map.put("count", COUNT_FIELD);
        map.put("statuses", STATUSES_FIELD);
        map.put("accounts", ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrganizationEntityAggregate, T> g) {
        return obj -> g.apply((OrganizationEntityAggregate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationEntityAggregate> {
        /**
         * <p>
         * A list of event ARNs (unique identifiers). For example:
         * <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
         * </p>
         * 
         * @param eventArn
         *        A list of event ARNs (unique identifiers). For example:
         *        <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventArn(String eventArn);

        /**
         * <p>
         * The number of entities for the organization that match the filter criteria for the specified events.
         * </p>
         * 
         * @param count
         *        The number of entities for the organization that match the filter criteria for the specified events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The number of affected entities aggregated by the entitiy status codes.
         * </p>
         * 
         * @param statuses
         *        The number of affected entities aggregated by the entitiy status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(Map<String, Integer> statuses);

        /**
         * <p>
         * The number of affected entities aggregated by the entitiy status codes.
         * </p>
         * 
         * @param statuses
         *        The number of affected entities aggregated by the entitiy status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Map<EntityStatusCode, Integer> statuses);

        /**
         * <p>
         * A list of entity aggregates for each of the specified accounts in your organization that are affected by a
         * specific event. If there are no <code>awsAccountIds</code> provided in the request, this field will be empty
         * in the response.
         * </p>
         * 
         * @param accounts
         *        A list of entity aggregates for each of the specified accounts in your organization that are affected
         *        by a specific event. If there are no <code>awsAccountIds</code> provided in the request, this field
         *        will be empty in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Collection<AccountEntityAggregate> accounts);

        /**
         * <p>
         * A list of entity aggregates for each of the specified accounts in your organization that are affected by a
         * specific event. If there are no <code>awsAccountIds</code> provided in the request, this field will be empty
         * in the response.
         * </p>
         * 
         * @param accounts
         *        A list of entity aggregates for each of the specified accounts in your organization that are affected
         *        by a specific event. If there are no <code>awsAccountIds</code> provided in the request, this field
         *        will be empty in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(AccountEntityAggregate... accounts);

        /**
         * <p>
         * A list of entity aggregates for each of the specified accounts in your organization that are affected by a
         * specific event. If there are no <code>awsAccountIds</code> provided in the request, this field will be empty
         * in the response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.health.model.AccountEntityAggregate.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.health.model.AccountEntityAggregate#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.health.model.AccountEntityAggregate.Builder#build()} is called
         * immediately and its result is passed to {@link #accounts(List<AccountEntityAggregate>)}.
         * 
         * @param accounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.health.model.AccountEntityAggregate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accounts(java.util.Collection<AccountEntityAggregate>)
         */
        Builder accounts(Consumer<AccountEntityAggregate.Builder>... accounts);
    }

    static final class BuilderImpl implements Builder {
        private String eventArn;

        private Integer count;

        private Map<String, Integer> statuses = DefaultSdkAutoConstructMap.getInstance();

        private List<AccountEntityAggregate> accounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationEntityAggregate model) {
            eventArn(model.eventArn);
            count(model.count);
            statusesWithStrings(model.statuses);
            accounts(model.accounts);
        }

        public final String getEventArn() {
            return eventArn;
        }

        public final void setEventArn(String eventArn) {
            this.eventArn = eventArn;
        }

        @Override
        public final Builder eventArn(String eventArn) {
            this.eventArn = eventArn;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Map<String, Integer> getStatuses() {
            if (statuses instanceof SdkAutoConstructMap) {
                return null;
            }
            return statuses;
        }

        public final void setStatuses(Map<String, Integer> statuses) {
            this.statuses = _entityStatusesCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Map<String, Integer> statuses) {
            this.statuses = _entityStatusesCopier.copy(statuses);
            return this;
        }

        @Override
        public final Builder statuses(Map<EntityStatusCode, Integer> statuses) {
            this.statuses = _entityStatusesCopier.copyEnumToString(statuses);
            return this;
        }

        public final List<AccountEntityAggregate.Builder> getAccounts() {
            List<AccountEntityAggregate.Builder> result = AccountEntityAggregatesListCopier.copyToBuilder(this.accounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccounts(Collection<AccountEntityAggregate.BuilderImpl> accounts) {
            this.accounts = AccountEntityAggregatesListCopier.copyFromBuilder(accounts);
        }

        @Override
        public final Builder accounts(Collection<AccountEntityAggregate> accounts) {
            this.accounts = AccountEntityAggregatesListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(AccountEntityAggregate... accounts) {
            accounts(Arrays.asList(accounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Consumer<AccountEntityAggregate.Builder>... accounts) {
            accounts(Stream.of(accounts).map(c -> AccountEntityAggregate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public OrganizationEntityAggregate build() {
            return new OrganizationEntityAggregate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
