/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEntityAggregatesResponse extends HealthResponse implements
        ToCopyableBuilder<DescribeEntityAggregatesResponse.Builder, DescribeEntityAggregatesResponse> {
    private static final SdkField<List<EntityAggregate>> ENTITY_AGGREGATES_FIELD = SdkField
            .<List<EntityAggregate>> builder(MarshallingType.LIST)
            .memberName("entityAggregates")
            .getter(getter(DescribeEntityAggregatesResponse::entityAggregates))
            .setter(setter(Builder::entityAggregates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityAggregates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntityAggregate> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntityAggregate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_AGGREGATES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EntityAggregate> entityAggregates;

    private DescribeEntityAggregatesResponse(BuilderImpl builder) {
        super(builder);
        this.entityAggregates = builder.entityAggregates;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityAggregates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntityAggregates() {
        return entityAggregates != null && !(entityAggregates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The number of entities that are affected by each of the specified events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityAggregates} method.
     * </p>
     * 
     * @return The number of entities that are affected by each of the specified events.
     */
    public final List<EntityAggregate> entityAggregates() {
        return entityAggregates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityAggregates() ? entityAggregates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntityAggregatesResponse)) {
            return false;
        }
        DescribeEntityAggregatesResponse other = (DescribeEntityAggregatesResponse) obj;
        return hasEntityAggregates() == other.hasEntityAggregates()
                && Objects.equals(entityAggregates(), other.entityAggregates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEntityAggregatesResponse")
                .add("EntityAggregates", hasEntityAggregates() ? entityAggregates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entityAggregates":
            return Optional.ofNullable(clazz.cast(entityAggregates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entityAggregates", ENTITY_AGGREGATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEntityAggregatesResponse, T> g) {
        return obj -> g.apply((DescribeEntityAggregatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends HealthResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEntityAggregatesResponse> {
        /**
         * <p>
         * The number of entities that are affected by each of the specified events.
         * </p>
         * 
         * @param entityAggregates
         *        The number of entities that are affected by each of the specified events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityAggregates(Collection<EntityAggregate> entityAggregates);

        /**
         * <p>
         * The number of entities that are affected by each of the specified events.
         * </p>
         * 
         * @param entityAggregates
         *        The number of entities that are affected by each of the specified events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityAggregates(EntityAggregate... entityAggregates);

        /**
         * <p>
         * The number of entities that are affected by each of the specified events.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.health.model.EntityAggregate.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.health.model.EntityAggregate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.health.model.EntityAggregate.Builder#build()} is called immediately
         * and its result is passed to {@link #entityAggregates(List<EntityAggregate>)}.
         * 
         * @param entityAggregates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.health.model.EntityAggregate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityAggregates(java.util.Collection<EntityAggregate>)
         */
        Builder entityAggregates(Consumer<EntityAggregate.Builder>... entityAggregates);
    }

    static final class BuilderImpl extends HealthResponse.BuilderImpl implements Builder {
        private List<EntityAggregate> entityAggregates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntityAggregatesResponse model) {
            super(model);
            entityAggregates(model.entityAggregates);
        }

        public final List<EntityAggregate.Builder> getEntityAggregates() {
            List<EntityAggregate.Builder> result = EntityAggregateListCopier.copyToBuilder(this.entityAggregates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntityAggregates(Collection<EntityAggregate.BuilderImpl> entityAggregates) {
            this.entityAggregates = EntityAggregateListCopier.copyFromBuilder(entityAggregates);
        }

        @Override
        public final Builder entityAggregates(Collection<EntityAggregate> entityAggregates) {
            this.entityAggregates = EntityAggregateListCopier.copy(entityAggregates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityAggregates(EntityAggregate... entityAggregates) {
            entityAggregates(Arrays.asList(entityAggregates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityAggregates(Consumer<EntityAggregate.Builder>... entityAggregates) {
            entityAggregates(Stream.of(entityAggregates).map(c -> EntityAggregate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEntityAggregatesResponse build() {
            return new DescribeEntityAggregatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
