/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.health.HealthAsyncClient;
import software.amazon.awssdk.services.health.internal.UserAgentUtils;
import software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest;
import software.amazon.awssdk.services.health.model.DescribeEventAggregatesResponse;
import software.amazon.awssdk.services.health.model.EventAggregate;

public class DescribeEventAggregatesPublisher
implements SdkPublisher<DescribeEventAggregatesResponse> {
    private final HealthAsyncClient client;
    private final DescribeEventAggregatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEventAggregatesPublisher(HealthAsyncClient client, DescribeEventAggregatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEventAggregatesPublisher(HealthAsyncClient client, DescribeEventAggregatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEventAggregatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEventAggregatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventAggregate> eventAggregates() {
        Function<DescribeEventAggregatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventAggregates() != null) {
                return response.eventAggregates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeEventAggregatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeEventAggregatesResponseFetcher
    implements AsyncPageFetcher<DescribeEventAggregatesResponse> {
        private DescribeEventAggregatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventAggregatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeEventAggregatesResponse> nextPage(DescribeEventAggregatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventAggregatesPublisher.this.client.describeEventAggregates(DescribeEventAggregatesPublisher.this.firstRequest);
            }
            return DescribeEventAggregatesPublisher.this.client.describeEventAggregates((DescribeEventAggregatesRequest)((Object)DescribeEventAggregatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

