/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.EntityAccountFilter;
import software.amazon.awssdk.services.health.model.EventAccountFilter;
import software.amazon.awssdk.services.health.model.HealthRequest;
import software.amazon.awssdk.services.health.model.OrganizationEntityAccountFiltersListCopier;
import software.amazon.awssdk.services.health.model.OrganizationEntityFiltersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAffectedEntitiesForOrganizationRequest
extends HealthRequest
implements ToCopyableBuilder<Builder, DescribeAffectedEntitiesForOrganizationRequest> {
    private static final SdkField<List<EventAccountFilter>> ORGANIZATION_ENTITY_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("organizationEntityFilters").getter(DescribeAffectedEntitiesForOrganizationRequest.getter(DescribeAffectedEntitiesForOrganizationRequest::organizationEntityFilters)).setter(DescribeAffectedEntitiesForOrganizationRequest.setter(Builder::organizationEntityFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationEntityFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventAccountFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(DescribeAffectedEntitiesForOrganizationRequest.getter(DescribeAffectedEntitiesForOrganizationRequest::locale)).setter(DescribeAffectedEntitiesForOrganizationRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeAffectedEntitiesForOrganizationRequest.getter(DescribeAffectedEntitiesForOrganizationRequest::nextToken)).setter(DescribeAffectedEntitiesForOrganizationRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(DescribeAffectedEntitiesForOrganizationRequest.getter(DescribeAffectedEntitiesForOrganizationRequest::maxResults)).setter(DescribeAffectedEntitiesForOrganizationRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<List<EntityAccountFilter>> ORGANIZATION_ENTITY_ACCOUNT_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("organizationEntityAccountFilters").getter(DescribeAffectedEntitiesForOrganizationRequest.getter(DescribeAffectedEntitiesForOrganizationRequest::organizationEntityAccountFilters)).setter(DescribeAffectedEntitiesForOrganizationRequest.setter(Builder::organizationEntityAccountFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationEntityAccountFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityAccountFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ENTITY_FILTERS_FIELD, LOCALE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, ORGANIZATION_ENTITY_ACCOUNT_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAffectedEntitiesForOrganizationRequest.memberNameToFieldInitializer();
    private final List<EventAccountFilter> organizationEntityFilters;
    private final String locale;
    private final String nextToken;
    private final Integer maxResults;
    private final List<EntityAccountFilter> organizationEntityAccountFilters;

    private DescribeAffectedEntitiesForOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.organizationEntityFilters = builder.organizationEntityFilters;
        this.locale = builder.locale;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.organizationEntityAccountFilters = builder.organizationEntityAccountFilters;
    }

    @Deprecated
    public final boolean hasOrganizationEntityFilters() {
        return this.organizationEntityFilters != null && !(this.organizationEntityFilters instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<EventAccountFilter> organizationEntityFilters() {
        return this.organizationEntityFilters;
    }

    public final String locale() {
        return this.locale;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasOrganizationEntityAccountFilters() {
        return this.organizationEntityAccountFilters != null && !(this.organizationEntityAccountFilters instanceof SdkAutoConstructList);
    }

    public final List<EntityAccountFilter> organizationEntityAccountFilters() {
        return this.organizationEntityAccountFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationEntityFilters() ? this.organizationEntityFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationEntityAccountFilters() ? this.organizationEntityAccountFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAffectedEntitiesForOrganizationRequest)) {
            return false;
        }
        DescribeAffectedEntitiesForOrganizationRequest other = (DescribeAffectedEntitiesForOrganizationRequest)((Object)obj);
        return this.hasOrganizationEntityFilters() == other.hasOrganizationEntityFilters() && Objects.equals(this.organizationEntityFilters(), other.organizationEntityFilters()) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasOrganizationEntityAccountFilters() == other.hasOrganizationEntityAccountFilters() && Objects.equals(this.organizationEntityAccountFilters(), other.organizationEntityAccountFilters());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAffectedEntitiesForOrganizationRequest").add("OrganizationEntityFilters", this.hasOrganizationEntityFilters() ? this.organizationEntityFilters() : null).add("Locale", (Object)this.locale()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("OrganizationEntityAccountFilters", this.hasOrganizationEntityAccountFilters() ? this.organizationEntityAccountFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "organizationEntityFilters": {
                return Optional.ofNullable(clazz.cast(this.organizationEntityFilters()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "organizationEntityAccountFilters": {
                return Optional.ofNullable(clazz.cast(this.organizationEntityAccountFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("organizationEntityFilters", ORGANIZATION_ENTITY_FILTERS_FIELD);
        map.put("locale", LOCALE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("organizationEntityAccountFilters", ORGANIZATION_ENTITY_ACCOUNT_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAffectedEntitiesForOrganizationRequest, T> g) {
        return obj -> g.apply((DescribeAffectedEntitiesForOrganizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthRequest.BuilderImpl
    implements Builder {
        private List<EventAccountFilter> organizationEntityFilters = DefaultSdkAutoConstructList.getInstance();
        private String locale;
        private String nextToken;
        private Integer maxResults;
        private List<EntityAccountFilter> organizationEntityAccountFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAffectedEntitiesForOrganizationRequest model) {
            super(model);
            this.organizationEntityFilters(model.organizationEntityFilters);
            this.locale(model.locale);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.organizationEntityAccountFilters(model.organizationEntityAccountFilters);
        }

        @Deprecated
        public final List<EventAccountFilter.Builder> getOrganizationEntityFilters() {
            List<EventAccountFilter.Builder> result = OrganizationEntityFiltersListCopier.copyToBuilder(this.organizationEntityFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setOrganizationEntityFilters(Collection<EventAccountFilter.BuilderImpl> organizationEntityFilters) {
            this.organizationEntityFilters = OrganizationEntityFiltersListCopier.copyFromBuilder(organizationEntityFilters);
        }

        @Override
        @Deprecated
        public final Builder organizationEntityFilters(Collection<EventAccountFilter> organizationEntityFilters) {
            this.organizationEntityFilters = OrganizationEntityFiltersListCopier.copy(organizationEntityFilters);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder organizationEntityFilters(EventAccountFilter ... organizationEntityFilters) {
            this.organizationEntityFilters(Arrays.asList(organizationEntityFilters));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder organizationEntityFilters(Consumer<EventAccountFilter.Builder> ... organizationEntityFilters) {
            this.organizationEntityFilters(Stream.of(organizationEntityFilters).map(c -> (EventAccountFilter)((EventAccountFilter.Builder)EventAccountFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<EntityAccountFilter.Builder> getOrganizationEntityAccountFilters() {
            List<EntityAccountFilter.Builder> result = OrganizationEntityAccountFiltersListCopier.copyToBuilder(this.organizationEntityAccountFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationEntityAccountFilters(Collection<EntityAccountFilter.BuilderImpl> organizationEntityAccountFilters) {
            this.organizationEntityAccountFilters = OrganizationEntityAccountFiltersListCopier.copyFromBuilder(organizationEntityAccountFilters);
        }

        @Override
        public final Builder organizationEntityAccountFilters(Collection<EntityAccountFilter> organizationEntityAccountFilters) {
            this.organizationEntityAccountFilters = OrganizationEntityAccountFiltersListCopier.copy(organizationEntityAccountFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationEntityAccountFilters(EntityAccountFilter ... organizationEntityAccountFilters) {
            this.organizationEntityAccountFilters(Arrays.asList(organizationEntityAccountFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationEntityAccountFilters(Consumer<EntityAccountFilter.Builder> ... organizationEntityAccountFilters) {
            this.organizationEntityAccountFilters(Stream.of(organizationEntityAccountFilters).map(c -> (EntityAccountFilter)((EntityAccountFilter.Builder)EntityAccountFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAffectedEntitiesForOrganizationRequest build() {
            return new DescribeAffectedEntitiesForOrganizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends HealthRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAffectedEntitiesForOrganizationRequest> {
        @Deprecated
        public Builder organizationEntityFilters(Collection<EventAccountFilter> var1);

        @Deprecated
        public Builder organizationEntityFilters(EventAccountFilter ... var1);

        @Deprecated
        public Builder organizationEntityFilters(Consumer<EventAccountFilter.Builder> ... var1);

        public Builder locale(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder organizationEntityAccountFilters(Collection<EntityAccountFilter> var1);

        public Builder organizationEntityAccountFilters(EntityAccountFilter ... var1);

        public Builder organizationEntityAccountFilters(Consumer<EntityAccountFilter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

