/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.health.HealthAsyncClient;
import software.amazon.awssdk.services.health.model.DescribeEventTypesRequest;
import software.amazon.awssdk.services.health.model.DescribeEventTypesResponse;
import software.amazon.awssdk.services.health.model.EventType;

public class DescribeEventTypesPublisher
implements SdkPublisher<DescribeEventTypesResponse> {
    private final HealthAsyncClient client;
    private final DescribeEventTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEventTypesPublisher(HealthAsyncClient client, DescribeEventTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEventTypesPublisher(HealthAsyncClient client, DescribeEventTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEventTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEventTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventType> eventTypes() {
        Function<DescribeEventTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventTypes() != null) {
                return response.eventTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeEventTypesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeEventTypesPublisher resume(DescribeEventTypesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEventTypesPublisher(this.client, (DescribeEventTypesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeEventTypesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeEventTypesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeEventTypesResponseFetcher
    implements AsyncPageFetcher<DescribeEventTypesResponse> {
        private DescribeEventTypesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeEventTypesResponse> nextPage(DescribeEventTypesResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventTypesPublisher.this.client.describeEventTypes(DescribeEventTypesPublisher.this.firstRequest);
            }
            return DescribeEventTypesPublisher.this.client.describeEventTypes((DescribeEventTypesRequest)((Object)DescribeEventTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

