/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.EntityStatusCode;
import software.amazon.awssdk.services.health.model._entityStatusCodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityAccountFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityAccountFilter> {
    private static final SdkField<String> EVENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventArn").getter(EntityAccountFilter.getter(EntityAccountFilter::eventArn)).setter(EntityAccountFilter.setter(Builder::eventArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventArn").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(EntityAccountFilter.getter(EntityAccountFilter::awsAccountId)).setter(EntityAccountFilter.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()}).build();
    private static final SdkField<List<String>> STATUS_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statusCodes").getter(EntityAccountFilter.getter(EntityAccountFilter::statusCodesAsStrings)).setter(EntityAccountFilter.setter(Builder::statusCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ARN_FIELD, AWS_ACCOUNT_ID_FIELD, STATUS_CODES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("eventArn", EVENT_ARN_FIELD);
            this.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("statusCodes", STATUS_CODES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String eventArn;
    private final String awsAccountId;
    private final List<String> statusCodes;

    private EntityAccountFilter(BuilderImpl builder) {
        this.eventArn = builder.eventArn;
        this.awsAccountId = builder.awsAccountId;
        this.statusCodes = builder.statusCodes;
    }

    public final String eventArn() {
        return this.eventArn;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final List<EntityStatusCode> statusCodes() {
        return _entityStatusCodeListCopier.copyStringToEnum(this.statusCodes);
    }

    public final boolean hasStatusCodes() {
        return this.statusCodes != null && !(this.statusCodes instanceof SdkAutoConstructList);
    }

    public final List<String> statusCodesAsStrings() {
        return this.statusCodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusCodes() ? this.statusCodesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityAccountFilter)) {
            return false;
        }
        EntityAccountFilter other = (EntityAccountFilter)obj;
        return Objects.equals(this.eventArn(), other.eventArn()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && this.hasStatusCodes() == other.hasStatusCodes() && Objects.equals(this.statusCodesAsStrings(), other.statusCodesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"EntityAccountFilter").add("EventArn", (Object)this.eventArn()).add("AwsAccountId", (Object)this.awsAccountId()).add("StatusCodes", this.hasStatusCodes() ? this.statusCodesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventArn": {
                return Optional.ofNullable(clazz.cast(this.eventArn()));
            }
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "statusCodes": {
                return Optional.ofNullable(clazz.cast(this.statusCodesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EntityAccountFilter, T> g) {
        return obj -> g.apply((EntityAccountFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventArn;
        private String awsAccountId;
        private List<String> statusCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EntityAccountFilter model) {
            this.eventArn(model.eventArn);
            this.awsAccountId(model.awsAccountId);
            this.statusCodesWithStrings(model.statusCodes);
        }

        public final String getEventArn() {
            return this.eventArn;
        }

        public final void setEventArn(String eventArn) {
            this.eventArn = eventArn;
        }

        @Override
        public final Builder eventArn(String eventArn) {
            this.eventArn = eventArn;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Collection<String> getStatusCodes() {
            if (this.statusCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statusCodes;
        }

        public final void setStatusCodes(Collection<String> statusCodes) {
            this.statusCodes = _entityStatusCodeListCopier.copy(statusCodes);
        }

        @Override
        public final Builder statusCodesWithStrings(Collection<String> statusCodes) {
            this.statusCodes = _entityStatusCodeListCopier.copy(statusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusCodesWithStrings(String ... statusCodes) {
            this.statusCodesWithStrings(Arrays.asList(statusCodes));
            return this;
        }

        @Override
        public final Builder statusCodes(Collection<EntityStatusCode> statusCodes) {
            this.statusCodes = _entityStatusCodeListCopier.copyEnumToString(statusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusCodes(EntityStatusCode ... statusCodes) {
            this.statusCodes(Arrays.asList(statusCodes));
            return this;
        }

        public EntityAccountFilter build() {
            return new EntityAccountFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityAccountFilter> {
        public Builder eventArn(String var1);

        public Builder awsAccountId(String var1);

        public Builder statusCodesWithStrings(Collection<String> var1);

        public Builder statusCodesWithStrings(String ... var1);

        public Builder statusCodes(Collection<EntityStatusCode> var1);

        public Builder statusCodes(EntityStatusCode ... var1);
    }
}

