/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.EventAccountFilter;
import software.amazon.awssdk.services.health.model.HealthRequest;
import software.amazon.awssdk.services.health.model.OrganizationEventDetailFiltersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventDetailsForOrganizationRequest
extends HealthRequest
implements ToCopyableBuilder<Builder, DescribeEventDetailsForOrganizationRequest> {
    private static final SdkField<List<EventAccountFilter>> ORGANIZATION_EVENT_DETAIL_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("organizationEventDetailFilters").getter(DescribeEventDetailsForOrganizationRequest.getter(DescribeEventDetailsForOrganizationRequest::organizationEventDetailFilters)).setter(DescribeEventDetailsForOrganizationRequest.setter(Builder::organizationEventDetailFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationEventDetailFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventAccountFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(DescribeEventDetailsForOrganizationRequest.getter(DescribeEventDetailsForOrganizationRequest::locale)).setter(DescribeEventDetailsForOrganizationRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_EVENT_DETAIL_FILTERS_FIELD, LOCALE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("organizationEventDetailFilters", ORGANIZATION_EVENT_DETAIL_FILTERS_FIELD);
            this.put("locale", LOCALE_FIELD);
        }
    });
    private final List<EventAccountFilter> organizationEventDetailFilters;
    private final String locale;

    private DescribeEventDetailsForOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.organizationEventDetailFilters = builder.organizationEventDetailFilters;
        this.locale = builder.locale;
    }

    public final boolean hasOrganizationEventDetailFilters() {
        return this.organizationEventDetailFilters != null && !(this.organizationEventDetailFilters instanceof SdkAutoConstructList);
    }

    public final List<EventAccountFilter> organizationEventDetailFilters() {
        return this.organizationEventDetailFilters;
    }

    public final String locale() {
        return this.locale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationEventDetailFilters() ? this.organizationEventDetailFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventDetailsForOrganizationRequest)) {
            return false;
        }
        DescribeEventDetailsForOrganizationRequest other = (DescribeEventDetailsForOrganizationRequest)((Object)obj);
        return this.hasOrganizationEventDetailFilters() == other.hasOrganizationEventDetailFilters() && Objects.equals(this.organizationEventDetailFilters(), other.organizationEventDetailFilters()) && Objects.equals(this.locale(), other.locale());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEventDetailsForOrganizationRequest").add("OrganizationEventDetailFilters", this.hasOrganizationEventDetailFilters() ? this.organizationEventDetailFilters() : null).add("Locale", (Object)this.locale()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "organizationEventDetailFilters": {
                return Optional.ofNullable(clazz.cast(this.organizationEventDetailFilters()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventDetailsForOrganizationRequest, T> g) {
        return obj -> g.apply((DescribeEventDetailsForOrganizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthRequest.BuilderImpl
    implements Builder {
        private List<EventAccountFilter> organizationEventDetailFilters = DefaultSdkAutoConstructList.getInstance();
        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventDetailsForOrganizationRequest model) {
            super(model);
            this.organizationEventDetailFilters(model.organizationEventDetailFilters);
            this.locale(model.locale);
        }

        public final List<EventAccountFilter.Builder> getOrganizationEventDetailFilters() {
            List<EventAccountFilter.Builder> result = OrganizationEventDetailFiltersListCopier.copyToBuilder(this.organizationEventDetailFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationEventDetailFilters(Collection<EventAccountFilter.BuilderImpl> organizationEventDetailFilters) {
            this.organizationEventDetailFilters = OrganizationEventDetailFiltersListCopier.copyFromBuilder(organizationEventDetailFilters);
        }

        @Override
        public final Builder organizationEventDetailFilters(Collection<EventAccountFilter> organizationEventDetailFilters) {
            this.organizationEventDetailFilters = OrganizationEventDetailFiltersListCopier.copy(organizationEventDetailFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationEventDetailFilters(EventAccountFilter ... organizationEventDetailFilters) {
            this.organizationEventDetailFilters(Arrays.asList(organizationEventDetailFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationEventDetailFilters(Consumer<EventAccountFilter.Builder> ... organizationEventDetailFilters) {
            this.organizationEventDetailFilters(Stream.of(organizationEventDetailFilters).map(c -> (EventAccountFilter)((EventAccountFilter.Builder)EventAccountFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEventDetailsForOrganizationRequest build() {
            return new DescribeEventDetailsForOrganizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends HealthRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEventDetailsForOrganizationRequest> {
        public Builder organizationEventDetailFilters(Collection<EventAccountFilter> var1);

        public Builder organizationEventDetailFilters(EventAccountFilter ... var1);

        public Builder organizationEventDetailFilters(Consumer<EventAccountFilter.Builder> ... var1);

        public Builder locale(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

