/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.HealthResponse;
import software.amazon.awssdk.services.health.model.OrganizationEntityAggregate;
import software.amazon.awssdk.services.health.model.OrganizationEntityAggregatesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEntityAggregatesForOrganizationResponse
extends HealthResponse
implements ToCopyableBuilder<Builder, DescribeEntityAggregatesForOrganizationResponse> {
    private static final SdkField<List<OrganizationEntityAggregate>> ORGANIZATION_ENTITY_AGGREGATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("organizationEntityAggregates").getter(DescribeEntityAggregatesForOrganizationResponse.getter(DescribeEntityAggregatesForOrganizationResponse::organizationEntityAggregates)).setter(DescribeEntityAggregatesForOrganizationResponse.setter(Builder::organizationEntityAggregates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationEntityAggregates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationEntityAggregate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ENTITY_AGGREGATES_FIELD));
    private final List<OrganizationEntityAggregate> organizationEntityAggregates;

    private DescribeEntityAggregatesForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.organizationEntityAggregates = builder.organizationEntityAggregates;
    }

    public final boolean hasOrganizationEntityAggregates() {
        return this.organizationEntityAggregates != null && !(this.organizationEntityAggregates instanceof SdkAutoConstructList);
    }

    public final List<OrganizationEntityAggregate> organizationEntityAggregates() {
        return this.organizationEntityAggregates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationEntityAggregates() ? this.organizationEntityAggregates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntityAggregatesForOrganizationResponse)) {
            return false;
        }
        DescribeEntityAggregatesForOrganizationResponse other = (DescribeEntityAggregatesForOrganizationResponse)((Object)obj);
        return this.hasOrganizationEntityAggregates() == other.hasOrganizationEntityAggregates() && Objects.equals(this.organizationEntityAggregates(), other.organizationEntityAggregates());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEntityAggregatesForOrganizationResponse").add("OrganizationEntityAggregates", this.hasOrganizationEntityAggregates() ? this.organizationEntityAggregates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "organizationEntityAggregates": {
                return Optional.ofNullable(clazz.cast(this.organizationEntityAggregates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEntityAggregatesForOrganizationResponse, T> g) {
        return obj -> g.apply((DescribeEntityAggregatesForOrganizationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthResponse.BuilderImpl
    implements Builder {
        private List<OrganizationEntityAggregate> organizationEntityAggregates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntityAggregatesForOrganizationResponse model) {
            super(model);
            this.organizationEntityAggregates(model.organizationEntityAggregates);
        }

        public final List<OrganizationEntityAggregate.Builder> getOrganizationEntityAggregates() {
            List<OrganizationEntityAggregate.Builder> result = OrganizationEntityAggregatesListCopier.copyToBuilder(this.organizationEntityAggregates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationEntityAggregates(Collection<OrganizationEntityAggregate.BuilderImpl> organizationEntityAggregates) {
            this.organizationEntityAggregates = OrganizationEntityAggregatesListCopier.copyFromBuilder(organizationEntityAggregates);
        }

        @Override
        public final Builder organizationEntityAggregates(Collection<OrganizationEntityAggregate> organizationEntityAggregates) {
            this.organizationEntityAggregates = OrganizationEntityAggregatesListCopier.copy(organizationEntityAggregates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationEntityAggregates(OrganizationEntityAggregate ... organizationEntityAggregates) {
            this.organizationEntityAggregates(Arrays.asList(organizationEntityAggregates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationEntityAggregates(Consumer<OrganizationEntityAggregate.Builder> ... organizationEntityAggregates) {
            this.organizationEntityAggregates(Stream.of(organizationEntityAggregates).map(c -> (OrganizationEntityAggregate)((OrganizationEntityAggregate.Builder)OrganizationEntityAggregate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEntityAggregatesForOrganizationResponse build() {
            return new DescribeEntityAggregatesForOrganizationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HealthResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEntityAggregatesForOrganizationResponse> {
        public Builder organizationEntityAggregates(Collection<OrganizationEntityAggregate> var1);

        public Builder organizationEntityAggregates(OrganizationEntityAggregate ... var1);

        public Builder organizationEntityAggregates(Consumer<OrganizationEntityAggregate.Builder> ... var1);
    }
}

