/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.health.HealthClient;
import software.amazon.awssdk.services.health.internal.UserAgentUtils;
import software.amazon.awssdk.services.health.model.DescribeEventTypesRequest;
import software.amazon.awssdk.services.health.model.DescribeEventTypesResponse;
import software.amazon.awssdk.services.health.model.EventType;

public class DescribeEventTypesIterable
implements SdkIterable<DescribeEventTypesResponse> {
    private final HealthClient client;
    private final DescribeEventTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEventTypesIterable(HealthClient client, DescribeEventTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeEventTypesResponseFetcher();
    }

    public Iterator<DescribeEventTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventType> eventTypes() {
        Function<DescribeEventTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventTypes() != null) {
                return response.eventTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeEventTypesResponseFetcher
    implements SyncPageFetcher<DescribeEventTypesResponse> {
        private DescribeEventTypesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeEventTypesResponse nextPage(DescribeEventTypesResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventTypesIterable.this.client.describeEventTypes(DescribeEventTypesIterable.this.firstRequest);
            }
            return DescribeEventTypesIterable.this.client.describeEventTypes((DescribeEventTypesRequest)((Object)DescribeEventTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

