/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventStatusCode {
    OPEN("open"),
    CLOSED("closed"),
    UPCOMING("upcoming"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventStatusCode> VALUE_MAP;
    private final String value;

    private EventStatusCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventStatusCode> knownValues() {
        EnumSet<EventStatusCode> knownValues = EnumSet.allOf(EventStatusCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventStatusCode.class, EventStatusCode::toString);
    }
}

