/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.health.HealthClient;
import software.amazon.awssdk.services.health.internal.UserAgentUtils;
import software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationRequest;
import software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationResponse;
import software.amazon.awssdk.services.health.model.OrganizationEvent;

public class DescribeEventsForOrganizationIterable
implements SdkIterable<DescribeEventsForOrganizationResponse> {
    private final HealthClient client;
    private final DescribeEventsForOrganizationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEventsForOrganizationIterable(HealthClient client, DescribeEventsForOrganizationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeEventsForOrganizationResponseFetcher();
    }

    public Iterator<DescribeEventsForOrganizationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OrganizationEvent> events() {
        Function<DescribeEventsForOrganizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeEventsForOrganizationResponseFetcher
    implements SyncPageFetcher<DescribeEventsForOrganizationResponse> {
        private DescribeEventsForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventsForOrganizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeEventsForOrganizationResponse nextPage(DescribeEventsForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventsForOrganizationIterable.this.client.describeEventsForOrganization(DescribeEventsForOrganizationIterable.this.firstRequest);
            }
            return DescribeEventsForOrganizationIterable.this.client.describeEventsForOrganization((DescribeEventsForOrganizationRequest)((Object)DescribeEventsForOrganizationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

